/*
 * Decompiled with CFR 0.152.
 */
package com.dingtalk.open.app.stream.network.api;

import java.util.HashMap;
import java.util.Map;

public enum TransportProtocol {
    WSS("wss", true),
    RSOCKET_TCP("rsocket", true);

    private String scheme;
    private boolean tls;
    private static final Map<String, TransportProtocol> MAPPING;

    private TransportProtocol(String scheme, boolean tls) {
        this.scheme = scheme;
        this.tls = tls;
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean isTls() {
        return this.tls;
    }

    public static TransportProtocol parseScheme(String scheme) {
        if (scheme == null) {
            return null;
        }
        return MAPPING.get(scheme);
    }

    static {
        MAPPING = new HashMap<String, TransportProtocol>();
        for (TransportProtocol value : TransportProtocol.values()) {
            MAPPING.put(value.scheme, value);
        }
    }
}

