/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.BaseGroovyExtension;
import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.HasBuiltinDelimiterForLicense;
import com.diffplug.gradle.spotless.JvmLang;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.generic.LicenseHeaderStep;
import java.io.File;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.GroovyBasePlugin;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.GroovySourceDirectorySet;

public class GroovyExtension
extends BaseGroovyExtension
implements HasBuiltinDelimiterForLicense,
JvmLang {
    private boolean excludeJava;
    static final String NAME = "groovy";

    @Inject
    public GroovyExtension(SpotlessExtension spotless) {
        super(spotless);
    }

    public void excludeJava() {
        this.excludeJava(true);
    }

    public void excludeJava(boolean excludeJava) {
        this.excludeJava = excludeJava;
    }

    @Override
    public FormatExtension.LicenseHeaderConfig licenseHeader(String licenseHeader) {
        return this.licenseHeader(licenseHeader, "(package|import|public|class|module) ");
    }

    @Override
    public FormatExtension.LicenseHeaderConfig licenseHeaderFile(Object licenseHeaderFile) {
        return this.licenseHeaderFile(licenseHeaderFile, "(package|import|public|class|module) ");
    }

    @Override
    protected void setupTask(SpotlessTask task) {
        if (this.target == null) {
            String message = "You must either specify 'target' manually or apply the 'groovy' plugin.";
            if (!this.getProject().getPlugins().hasPlugin(GroovyBasePlugin.class)) {
                throw new GradleException("You must either specify 'target' manually or apply the 'groovy' plugin.");
            }
            boolean excludeJavaValue = this.excludeJava;
            this.target = this.getSources(this.getProject(), "You must either specify 'target' manually or apply the 'groovy' plugin.", sourceSet -> (SourceDirectorySet)sourceSet.getExtensions().getByType(GroovySourceDirectorySet.class), (Spec<? super File>)((Spec)file -> {
                String name = file.getName();
                if (excludeJavaValue) {
                    return name.endsWith(".groovy");
                }
                return name.endsWith(".groovy") || name.endsWith(".java");
            }));
        } else if (this.excludeJava) {
            throw new IllegalArgumentException("'excludeJava' is not supported in combination with a custom 'target'.");
        }
        this.steps.replaceAll(step -> {
            if (this.isLicenseHeaderStep((FormatterStep)step)) {
                return step.filterByFile(LicenseHeaderStep.unsupportedJvmFilesFilter());
            }
            return step;
        });
        super.setupTask(task);
    }
}

