/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.SpotlessTaskService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="not worth caching")
public abstract class SpotlessApply
extends SpotlessTaskService.ClientTask {
    @TaskAction
    public void performAction() {
        ((SpotlessTaskService)this.getTaskService().get()).registerApplyAlreadyRan(this);
        ConfigurableFileTree cleanFiles = this.getConfigCacheWorkaround().fileTree().from(this.getSpotlessCleanDirectory().get());
        ConfigurableFileTree lintsFiles = this.getConfigCacheWorkaround().fileTree().from(this.getSpotlessLintsDirectory().get());
        if (cleanFiles.isEmpty() && lintsFiles.isEmpty()) {
            this.getState().setDidWork(this.sourceDidWork());
        } else {
            cleanFiles.visit(new FileVisitor(){

                public void visitDir(FileVisitDetails fileVisitDetails) {
                }

                public void visitFile(FileVisitDetails fileVisitDetails) {
                    String path = fileVisitDetails.getPath();
                    File originalSource = new File(((Directory)SpotlessApply.this.getProjectDir().get()).getAsFile(), path);
                    try {
                        SpotlessApply.this.getLogger().debug("Copying " + String.valueOf(fileVisitDetails.getFile()) + " to " + String.valueOf(originalSource));
                        Files.copy(fileVisitDetails.getFile().toPath(), originalSource.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            if (!lintsFiles.isEmpty()) {
                boolean detailed = false;
                throw new GradleException(super.allLintsErrorMsgDetailed(lintsFiles, detailed));
            }
        }
    }
}

