/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.biome.BiomeFlavor;
import com.diffplug.spotless.biome.BiomeStep;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.gradle.api.Project;

public abstract class BiomeStepConfig<Self extends BiomeStepConfig<Self>> {
    @Nullable
    private Object configPath;
    @Nullable
    private Object downloadDir;
    private final BiomeFlavor flavor;
    @Nullable
    private Object pathToExe;
    private final Project project;
    private final Consumer<FormatterStep> replaceStep;
    @Nullable
    private String version;

    protected BiomeStepConfig(Project project, Consumer<FormatterStep> replaceStep, BiomeFlavor flavor, String version) {
        this.project = Objects.requireNonNull(project);
        this.replaceStep = Objects.requireNonNull(replaceStep);
        this.flavor = flavor;
        this.version = version;
    }

    public Self configPath(Object configPath) {
        this.configPath = configPath;
        this.replaceStep();
        return this.getThis();
    }

    public Self downloadDir(Object downloadDir) {
        this.downloadDir = downloadDir;
        this.replaceStep();
        return this.getThis();
    }

    public Self pathToExe(Object pathToExe) {
        this.pathToExe = pathToExe;
        this.replaceStep();
        return this.getThis();
    }

    protected FormatterStep createStep() {
        BiomeStep builder = this.newBuilder();
        if (this.configPath != null) {
            File resolvedConfigPath = this.project.file(this.configPath);
            builder.withConfigPath(resolvedConfigPath.toString());
        }
        builder.withLanguage(this.getLanguage());
        return builder.create();
    }

    protected abstract String getLanguage();

    protected abstract Self getThis();

    protected void replaceStep() {
        this.replaceStep.accept(this.createStep());
    }

    private File findDataDir() {
        Path userHomeDir = this.project.getGradle().getGradleUserHomeDir().toPath();
        Path dataPath = userHomeDir.resolve("com").resolve("diffplug").resolve("spotless").resolve("spotless-data");
        return dataPath.toAbsolutePath().toFile();
    }

    private BiomeStep newBuilder() {
        if (this.pathToExe != null) {
            String resolvedPathToExe = this.resolvePathToExe();
            return BiomeStep.withExePath((BiomeFlavor)this.flavor, (String)resolvedPathToExe);
        }
        String downloadDir = this.resolveDownloadDir();
        return BiomeStep.withExeDownload((BiomeFlavor)this.flavor, (String)this.version, (String)downloadDir);
    }

    private String resolvePathToExe() {
        boolean fileNameOnly;
        boolean bl = fileNameOnly = this.pathToExe instanceof String && Paths.get(this.pathToExe.toString(), new String[0]).getNameCount() == 1;
        if (fileNameOnly) {
            return this.pathToExe.toString();
        }
        return this.project.file(this.pathToExe).toString();
    }

    private String resolveDownloadDir() {
        if (this.downloadDir != null) {
            return this.project.file(this.downloadDir).toString();
        }
        return this.findDataDir().toPath().resolve(this.flavor.shortName()).toString();
    }
}

