/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.json.JsonSimpleStep;
import com.diffplug.spotless.json.gson.GsonStep;
import javax.inject.Inject;

public class JsonExtension
extends FormatExtension {
    private static final int DEFAULT_INDENTATION = 4;
    private static final String DEFAULT_GSON_VERSION = "2.8.9";
    static final String NAME = "json";

    @Inject
    public JsonExtension(SpotlessExtension spotless) {
        super(spotless);
    }

    @Override
    protected void setupTask(SpotlessTask task) {
        if (this.target == null) {
            throw this.noDefaultTargetException();
        }
        super.setupTask(task);
    }

    public SimpleConfig simple() {
        return new SimpleConfig(4);
    }

    public GsonConfig gson() {
        return new GsonConfig();
    }

    public class GsonConfig {
        private int indentSpaces = 4;
        private boolean sortByKeys = false;
        private boolean escapeHtml = false;
        private String version = "2.8.9";

        public GsonConfig() {
            JsonExtension.this.addStep(this.createStep());
        }

        public GsonConfig indentWithSpaces(int indentSpaces) {
            this.indentSpaces = indentSpaces;
            JsonExtension.this.replaceStep(this.createStep());
            return this;
        }

        public GsonConfig sortByKeys() {
            this.sortByKeys = true;
            JsonExtension.this.replaceStep(this.createStep());
            return this;
        }

        public GsonConfig escapeHtml() {
            this.escapeHtml = true;
            JsonExtension.this.replaceStep(this.createStep());
            return this;
        }

        public GsonConfig version(String version) {
            this.version = version;
            JsonExtension.this.replaceStep(this.createStep());
            return this;
        }

        private FormatterStep createStep() {
            return GsonStep.create((int)this.indentSpaces, (boolean)this.sortByKeys, (boolean)this.escapeHtml, (String)this.version, (Provisioner)JsonExtension.this.provisioner());
        }
    }

    public class SimpleConfig {
        private int indent;

        public SimpleConfig(int indent) {
            this.indent = indent;
            JsonExtension.this.addStep(this.createStep());
        }

        public void indentWithSpaces(int indent) {
            this.indent = indent;
            JsonExtension.this.replaceStep(this.createStep());
        }

        private FormatterStep createStep() {
            return JsonSimpleStep.create((int)this.indent, (Provisioner)JsonExtension.this.provisioner());
        }
    }
}

