/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.shell.ShfmtStep;
import java.util.Objects;
import javax.inject.Inject;

public class ShellExtension
extends FormatExtension {
    private static final String SHELL_FILE_EXTENSION = "*.sh";
    static final String NAME = "shell";

    @Inject
    public ShellExtension(SpotlessExtension spotless) {
        super(spotless);
    }

    @Override
    protected void setupTask(SpotlessTask task) {
        if (this.target == null) {
            this.target = this.parseTarget(SHELL_FILE_EXTENSION);
        }
        super.setupTask(task);
    }

    public ShfmtExtension shfmt(String version) {
        Objects.requireNonNull(version);
        return new ShfmtExtension(version);
    }

    public ShfmtExtension shfmt() {
        return this.shfmt(ShfmtStep.defaultVersion());
    }

    public class ShfmtExtension {
        ShfmtStep step;

        ShfmtExtension(String version) {
            this.step = ShfmtStep.withVersion((String)version);
            ShellExtension.this.addStep(this.createStep());
        }

        public ShfmtExtension pathToExe(String pathToExe) {
            this.step = this.step.withPathToExe(pathToExe);
            ShellExtension.this.replaceStep(this.createStep());
            return this;
        }

        private FormatterStep createStep() {
            return this.step.create();
        }
    }
}

