/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import java.io.File;
import java.util.function.Function;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.util.GradleVersion;

interface JvmLang {
    default public FileCollection getSources(Project project, String message, Function<SourceSet, SourceDirectorySet> sourceSetSourceDirectory, Spec<? super File> filterSpec) {
        SourceSetContainer sourceSets;
        ConfigurableFileCollection union = project.files(new Object[0]);
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"7.1")) >= 0) {
            JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().findByType(JavaPluginExtension.class);
            if (javaPluginExtension == null) {
                throw new GradleException(message);
            }
            sourceSets = javaPluginExtension.getSourceSets();
        } else {
            JavaPluginConvention javaPluginConvention = (JavaPluginConvention)project.getConvention().findPlugin(JavaPluginConvention.class);
            if (javaPluginConvention == null) {
                throw new GradleException(message);
            }
            sourceSets = javaPluginConvention.getSourceSets();
        }
        for (SourceSet sourceSet : sourceSets) {
            union = union.plus(sourceSetSourceDirectory.apply(sourceSet).filter(filterSpec));
        }
        return union;
    }
}

