/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.JvmLang;
import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.scala.ScalaFmtStep;
import java.io.File;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.SourceSet;

public class ScalaExtension
extends FormatExtension
implements JvmLang {
    static final String NAME = "scala";

    @Inject
    public ScalaExtension(SpotlessExtension spotless) {
        super(spotless);
    }

    public ScalaFmtConfig scalafmt() {
        return this.scalafmt(ScalaFmtStep.defaultVersion());
    }

    public ScalaFmtConfig scalafmt(String version) {
        return new ScalaFmtConfig(version);
    }

    @Override
    protected void setupTask(SpotlessTask task) {
        if (this.target == null) {
            this.target = this.getSources(this.getProject(), "You must either specify 'target' manually or apply the 'scala' plugin.", SourceSet::getAllSource, (Spec<? super File>)((Spec)file -> {
                String name = file.getName();
                return name.endsWith(".scala") || name.endsWith(".sc");
            }));
        }
        super.setupTask(task);
    }

    public class ScalaFmtConfig {
        final String version;
        @Nullable
        String scalaMajorVersion;
        @Nullable
        Object configFile;

        ScalaFmtConfig(String version) {
            this.version = Objects.requireNonNull(version);
            ScalaExtension.this.addStep(this.createStep());
        }

        public ScalaFmtConfig configFile(Object configFile) {
            this.configFile = Objects.requireNonNull(configFile);
            ScalaExtension.this.replaceStep(this.createStep());
            return this;
        }

        public ScalaFmtConfig scalaMajorVersion(String scalaMajorVersion) {
            this.scalaMajorVersion = Objects.requireNonNull(scalaMajorVersion);
            ScalaExtension.this.replaceStep(this.createStep());
            return this;
        }

        private FormatterStep createStep() {
            File resolvedConfigFile = this.configFile == null ? null : ScalaExtension.this.getProject().file(this.configFile);
            return ScalaFmtStep.create((String)this.version, (String)this.scalaMajorVersion, (Provisioner)ScalaExtension.this.provisioner(), (File)resolvedConfigFile);
        }
    }
}

