/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.common.base.Preconditions;
import com.diffplug.common.io.Files;
import com.diffplug.gradle.spotless.GitRatchetGradle;
import com.diffplug.gradle.spotless.GradleProvisioner;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.FormatterStep;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.build.event.BuildEventsListenerRegistry;

public abstract class RegisterDependenciesTask
extends DefaultTask {
    static final String TASK_NAME = "spotlessInternalRegisterDependencies";
    private List<SpotlessTask> tasks = new ArrayList<SpotlessTask>();
    File unitOutput;
    GradleProvisioner.RootProvisioner rootProvisioner;

    @Input
    public List<FormatterStep> getSteps() {
        ArrayList<FormatterStep> allSteps = new ArrayList<FormatterStep>();
        TaskExecutionGraph taskGraph = this.getProject().getGradle().getTaskGraph();
        this.tasks.stream().filter(arg_0 -> ((TaskExecutionGraph)taskGraph).hasTask(arg_0)).sorted().forEach(task -> allSteps.addAll(task.getSteps()));
        return allSteps;
    }

    @Internal
    public List<SpotlessTask> getTasks() {
        return this.tasks;
    }

    void hookSubprojectTask(SpotlessTask task) {
        this.tasks.add(task);
        task.dependsOn(new Object[]{this});
    }

    @OutputFile
    public File getUnitOutput() {
        return this.unitOutput;
    }

    @Internal
    public GradleProvisioner.RootProvisioner getRootProvisioner() {
        return this.rootProvisioner;
    }

    void setup() {
        Preconditions.checkArgument((this.getProject().getRootProject() == this.getProject() ? 1 : 0) != 0, (Object)"Can only be used on the root project");
        this.unitOutput = new File(this.getProject().getBuildDir(), "tmp/spotless-register-dependencies");
        this.rootProvisioner = new GradleProvisioner.RootProvisioner(this.getProject());
        Provider gitRatchetProvider = this.getProject().getGradle().getSharedServices().registerIfAbsent("GitRatchetGradle", GitRatchetGradle.class, unused -> {});
        this.getBuildEventsListenerRegistry().onTaskCompletion(gitRatchetProvider);
        this.getGitRatchet().set(gitRatchetProvider);
    }

    @TaskAction
    public void trivialFunction() throws IOException {
        Files.createParentDirs((File)this.unitOutput);
        Files.write((CharSequence)Integer.toString(this.getSteps().size()), (File)this.unitOutput, (Charset)StandardCharsets.UTF_8);
    }

    @Internal
    public abstract Property<GitRatchetGradle> getGitRatchet();

    @Inject
    protected abstract BuildEventsListenerRegistry getBuildEventsListenerRegistry();
}

