/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.SpotlessCache;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import groovy.lang.Closure;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.plugins.BasePlugin;

public class SpotlessPlugin
implements Plugin<Project> {
    SpotlessExtension spotlessExtension;
    static final String EXTENSION = "spotless";
    static final String CHECK = "Check";
    static final String APPLY = "Apply";
    private static final String TASK_GROUP = "Verification";
    private static final String CHECK_DESCRIPTION = "Checks that sourcecode satisfies formatting steps.";
    private static final String APPLY_DESCRIPTION = "Applies code formatting steps to sourcecode in-place.";

    public void apply(Project project) {
        project.getPlugins().apply(BasePlugin.class);
        this.spotlessExtension = (SpotlessExtension)project.getExtensions().create(EXTENSION, SpotlessExtension.class, new Object[]{project});
        project.afterEvaluate(this::createTasks);
    }

    public SpotlessExtension getExtension() {
        return this.spotlessExtension;
    }

    void createTasks(Project project) {
        Task rootCheckTask = project.task("spotlessCheck");
        rootCheckTask.setGroup(TASK_GROUP);
        rootCheckTask.setDescription(CHECK_DESCRIPTION);
        Task rootApplyTask = project.task("spotlessApply");
        rootApplyTask.setGroup(TASK_GROUP);
        rootApplyTask.setDescription(APPLY_DESCRIPTION);
        this.spotlessExtension.formats.forEach((key, value) -> {
            String taskName = EXTENSION + SpotlessPlugin.capitalize(key);
            final SpotlessTask spotlessTask = (SpotlessTask)project.getTasks().create(taskName, SpotlessTask.class);
            value.setupTask(spotlessTask);
            final Task checkTask = project.getTasks().create(taskName + CHECK);
            final Task applyTask = project.getTasks().create(taskName + APPLY);
            rootCheckTask.dependsOn(new Object[]{checkTask});
            rootApplyTask.dependsOn(new Object[]{applyTask});
            checkTask.dependsOn(new Object[]{spotlessTask});
            applyTask.dependsOn(new Object[]{spotlessTask});
            project.getGradle().getTaskGraph().whenReady(new Closure(null){
                private static final long serialVersionUID = 1L;

                @SuppressFBWarnings(value={"UMAC_UNCALLABLE_METHOD_OF_ANONYMOUS_CLASS"})
                public Object doCall(TaskExecutionGraph graph) {
                    if (graph.hasTask(checkTask)) {
                        spotlessTask.setCheck();
                    }
                    if (graph.hasTask(applyTask)) {
                        spotlessTask.setApply();
                    }
                    return 1;
                }
            });
        });
        if (this.spotlessExtension.enforceCheck) {
            project.getTasks().matching(task -> task.getName().equals("check")).all(task -> task.dependsOn(new Object[]{rootCheckTask}));
        }
        Task clean = project.getTasks().getByName("clean");
        clean.doLast(unused -> SpotlessCache.clear());
        project.getTasks().withType(SpotlessTask.class).all(task -> task.mustRunAfter(new Object[]{clean}));
    }

    static String capitalize(String input) {
        return Character.toUpperCase(input.charAt(0)) + input.substring(1);
    }
}

