/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven.generic;

import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.maven.FormatterStepConfig;
import com.diffplug.spotless.maven.npm.AbstractNpmFormatterStepFactory;
import com.diffplug.spotless.npm.NpmPathResolver;
import com.diffplug.spotless.npm.PrettierConfig;
import com.diffplug.spotless.npm.PrettierFormatterStep;
import java.io.File;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.maven.plugins.annotations.Parameter;

public class Prettier
extends AbstractNpmFormatterStepFactory {
    public static final String ERROR_MESSAGE_ONLY_ONE_CONFIG = "must specify exactly one prettierVersion, devDependencies or devDependencyProperties";
    @Parameter
    private String prettierVersion;
    @Parameter
    private Map<String, String> devDependencies;
    @Parameter
    private Properties devDependencyProperties;
    @Parameter
    private Map<String, String> config;
    @Parameter
    private String configFile;

    @Override
    public FormatterStep newFormatterStep(FormatterStepConfig stepConfig) {
        if (this.moreThanOneNonNull(this.prettierVersion, this.devDependencies, this.devDependencyProperties)) {
            throw Prettier.onlyOneConfig();
        }
        if (this.devDependencies == null) {
            this.devDependencies = PrettierFormatterStep.defaultDevDependencies();
        }
        if (this.prettierVersion != null && !this.prettierVersion.isEmpty()) {
            this.devDependencies = PrettierFormatterStep.defaultDevDependenciesWithPrettier((String)this.prettierVersion);
        } else if (this.devDependencyProperties != null) {
            this.devDependencies = this.propertiesAsMap(this.devDependencyProperties);
        }
        File configFileHandler = this.configFile != null ? stepConfig.getFileLocator().locateFile(this.configFile) : null;
        Map configInline = this.config != null ? (Map)this.config.entrySet().stream().map(entry -> {
            try {
                Integer value = Integer.parseInt((String)entry.getValue());
                return new AbstractMap.SimpleEntry<String, Integer>((String)entry.getKey(), value);
            }
            catch (NumberFormatException value) {
                if (Boolean.TRUE.toString().equalsIgnoreCase((String)entry.getValue()) || Boolean.FALSE.toString().equalsIgnoreCase((String)entry.getValue())) {
                    return new AbstractMap.SimpleEntry<String, Boolean>((String)entry.getKey(), Boolean.parseBoolean((String)entry.getValue()));
                }
                if ("plugins".equals(entry.getKey())) {
                    List values = ((String)entry.getValue()).isEmpty() ? List.of() : Arrays.asList(((String)entry.getValue()).split(","));
                    return new AbstractMap.SimpleEntry((String)entry.getKey(), values);
                }
                return entry;
            }
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, LinkedHashMap::new)) : null;
        File baseDir = this.baseDir(stepConfig);
        File buildDir = this.buildDir(stepConfig);
        File cacheDir = this.cacheDir(stepConfig);
        PrettierConfig prettierConfig = new PrettierConfig(configFileHandler, configInline);
        NpmPathResolver npmPathResolver = this.npmPathResolver(stepConfig);
        return PrettierFormatterStep.create(this.devDependencies, (Provisioner)stepConfig.getProvisioner(), (File)baseDir, (File)buildDir, (File)cacheDir, (NpmPathResolver)npmPathResolver, (PrettierConfig)prettierConfig);
    }

    private static IllegalArgumentException onlyOneConfig() {
        return new IllegalArgumentException(ERROR_MESSAGE_ONLY_ONE_CONFIG);
    }
}

