/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven;

import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.Lint;
import com.diffplug.spotless.LintState;
import com.diffplug.spotless.LintSuppression;
import com.diffplug.spotless.maven.AbstractSpotlessMojo;
import com.diffplug.spotless.maven.IdeHook;
import com.diffplug.spotless.maven.ImpactedFilesTracker;
import com.diffplug.spotless.maven.incremental.UpToDateChecker;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="apply", threadSafe=true)
public class SpotlessApplyMojo
extends AbstractSpotlessMojo {
    @Parameter(property="spotlessIdeHook")
    private String spotlessIdeHook;
    @Parameter(property="spotlessIdeHookUseStdIn")
    private boolean spotlessIdeHookUseStdIn;
    @Parameter(property="spotlessIdeHookUseStdOut")
    private boolean spotlessIdeHookUseStdOut;

    @Override
    protected void process(String name, Iterable<File> files, Formatter formatter, UpToDateChecker upToDateChecker) throws MojoExecutionException {
        if (this.isIdeHook()) {
            IdeHook.performHook(files, formatter, this.spotlessIdeHook, this.spotlessIdeHookUseStdIn, this.spotlessIdeHookUseStdOut);
            return;
        }
        ImpactedFilesTracker counter = new ImpactedFilesTracker();
        for (File file : files) {
            if (upToDateChecker.isUpToDate(file.toPath())) {
                counter.skippedAsCleanCache();
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Spotless will not format an up-to-date file: " + String.valueOf(file)));
                continue;
            }
            try {
                LintState lintState = super.calculateLintState(formatter, file);
                boolean hasDirtyState = !lintState.getDirtyState().isClean() && !lintState.getDirtyState().didNotConverge();
                boolean hasUnsuppressedLints = lintState.isHasLints();
                if (hasDirtyState) {
                    this.getLog().info((CharSequence)"clean file: %s".formatted(file));
                    lintState.getDirtyState().writeCanonicalTo(file);
                    this.buildContext.refresh(file);
                    counter.cleaned();
                } else {
                    counter.checkedButAlreadyClean();
                }
                if (hasUnsuppressedLints) {
                    int lintCount = lintState.getLintsByStep(formatter).values().stream().mapToInt(List::size).sum();
                    StringBuilder message = new StringBuilder();
                    message.append("There were ").append(lintCount).append(" lint error(s), they must be fixed or suppressed.");
                    for (Map.Entry stepEntry : lintState.getLintsByStep(formatter).entrySet()) {
                        String stepName = (String)stepEntry.getKey();
                        for (Lint lint : (List)stepEntry.getValue()) {
                            String relativePath = LintSuppression.relativizeAsUnix((File)this.baseDir, (File)file);
                            message.append("\n  ").append(relativePath).append(":");
                            lint.addWarningMessageTo(message, stepName, true);
                        }
                    }
                    message.append("\n  Resolve these lints or suppress with `<lintSuppressions>`");
                    throw new MojoExecutionException(message.toString());
                }
            }
            catch (IOException | RuntimeException e) {
                throw new MojoExecutionException("Unable to format file " + String.valueOf(file), e);
            }
            upToDateChecker.setUpToDate(file.toPath());
        }
        if (counter.getTotal() > 0) {
            this.getLog().info((CharSequence)"Spotless.%s is keeping %s files clean - %s were changed to be clean, %s were already clean, %s were skipped because caching determined they were already clean".formatted(name, counter.getTotal(), counter.getCleaned(), counter.getCheckedButAlreadyClean(), counter.getSkippedAsCleanCache()));
        } else {
            this.getLog().debug((CharSequence)"Spotless.%s has no target files. Examine your `<includes>`: https://github.com/diffplug/spotless/tree/main/plugin-maven#quickstart".formatted(name));
        }
    }

    private boolean isIdeHook() {
        return this.spotlessIdeHook != null && !this.spotlessIdeHook.isEmpty();
    }
}

