/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.glue.ktlint;

import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.Lint;
import com.diffplug.spotless.glue.ktlint.compat.KtLintCompat1Dot0Dot0Adapter;
import com.diffplug.spotless.glue.ktlint.compat.KtLintCompatAdapter;
import com.diffplug.spotless.glue.ktlint.compat.KtLintCompatReporting;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;

public class KtlintFormatterFunc
implements FormatterFunc.NeedsFile {
    private final KtLintCompatAdapter adapter;
    private final FileSignature editorConfigPath;
    private final Map<String, Object> editorConfigOverrideMap;

    public KtlintFormatterFunc(String version, FileSignature editorConfigPath, Map<String, Object> editorConfigOverrideMap) {
        String[] versions = version.split("\\.");
        int majorVersion = Integer.parseInt(versions[0]);
        if (majorVersion != 1) {
            throw new IllegalStateException("Ktlint versions < 1.0.0 not supported!");
        }
        this.adapter = new KtLintCompat1Dot0Dot0Adapter();
        this.editorConfigPath = editorConfigPath;
        this.editorConfigOverrideMap = editorConfigOverrideMap;
    }

    @Override
    public String applyWithFile(String unix, File file) throws NoSuchFieldException, IllegalAccessException {
        Path absoluteEditorConfigPath = null;
        if (this.editorConfigPath != null) {
            absoluteEditorConfigPath = this.editorConfigPath.getOnlyFile().toPath();
        }
        try {
            return this.adapter.format(unix, file.toPath(), absoluteEditorConfigPath, this.editorConfigOverrideMap);
        }
        catch (KtLintCompatReporting.KtlintSpotlessException e) {
            throw Lint.atLine(e.line, e.ruleId, e.detail).shortcut();
        }
    }
}

