/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.glue.javaparser;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.LineEnding;
import com.diffplug.spotless.Lint;
import com.github.javaparser.JavaParser;
import com.github.javaparser.Position;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.MarkerAnnotationExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithName;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import com.github.javaparser.resolution.SymbolResolver;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedAnnotationDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.JavaSymbolSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.CombinedTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.JarTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.JavaParserTypeSolver;
import com.github.javaparser.symbolsolver.resolution.typesolvers.ReflectionTypeSolver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javassist.ClassPool;

public class ExpandWildcardsFormatterFunc
implements FormatterFunc.NeedsFile {
    private final JavaParser parser = new JavaParser();

    public ExpandWildcardsFormatterFunc(Collection<File> typeSolverClasspath) throws IOException {
        CombinedTypeSolver combinedTypeSolver = new CombinedTypeSolver(new TypeSolver[0]);
        combinedTypeSolver.add((TypeSolver)new ReflectionTypeSolver());
        for (File element : typeSolverClasspath) {
            if (element.isFile()) {
                combinedTypeSolver.add((TypeSolver)new JarTypeSolver(element));
                continue;
            }
            if (!element.isDirectory()) continue;
            combinedTypeSolver.add((TypeSolver)new JavaParserTypeSolver(element));
        }
        JavaSymbolSolver symbolSolver = new JavaSymbolSolver((TypeSolver)combinedTypeSolver);
        this.parser.getParserConfiguration().setSymbolResolver((SymbolResolver)symbolSolver);
    }

    @Override
    public String applyWithFile(String rawUnix, File file) throws Exception {
        Optional parseResult = this.parser.parse(rawUnix).getResult();
        if (parseResult.isEmpty()) {
            return rawUnix;
        }
        CompilationUnit cu = (CompilationUnit)parseResult.get();
        Map importMap = this.findWildcardImports(cu).stream().collect(Collectors.toMap(Function.identity(), t -> new TreeSet<ImportDeclaration>(Comparator.comparing(NodeWithName::getNameAsString))));
        if (importMap.isEmpty()) {
            return rawUnix;
        }
        cu.accept((VoidVisitor)new CollectImportedTypesVisitor(), importMap);
        for (Map.Entry entry : importMap.entrySet()) {
            String pattern = Pattern.quote(LineEnding.toUnix(((ImportDeclaration)entry.getKey()).toString()));
            String replacement = entry.getValue().stream().map(Node::toString).collect(Collectors.joining());
            rawUnix = rawUnix.replaceAll(pattern, replacement);
        }
        return rawUnix;
    }

    private List<ImportDeclaration> findWildcardImports(CompilationUnit cu) {
        ArrayList<ImportDeclaration> wildcardImports = new ArrayList<ImportDeclaration>();
        for (ImportDeclaration importDeclaration : cu.getImports()) {
            if (!importDeclaration.isAsterisk()) continue;
            wildcardImports.add(importDeclaration);
        }
        return wildcardImports;
    }

    static {
        ClassPool.cacheOpenedJarFile = false;
    }

    private static final class CollectImportedTypesVisitor
    extends VoidVisitorAdapter<Map<ImportDeclaration, Set<ImportDeclaration>>> {
        private CollectImportedTypesVisitor() {
        }

        public void visit(ClassOrInterfaceType n, Map<ImportDeclaration, Set<ImportDeclaration>> importMap) {
            ResolvedType resolvedType = CollectImportedTypesVisitor.wrapUnsolvedSymbolException(n, ClassOrInterfaceType::resolve);
            if (resolvedType.isReference()) {
                this.matchTypeName(importMap, resolvedType.asReferenceType().getQualifiedName(), false);
            }
            super.visit(n, importMap);
        }

        private void matchTypeName(Map<ImportDeclaration, Set<ImportDeclaration>> importMap, String qualifiedName, boolean isStatic) {
            int lastDot = qualifiedName.lastIndexOf(46);
            if (lastDot < 0) {
                return;
            }
            String packageName = qualifiedName.substring(0, lastDot);
            for (Map.Entry<ImportDeclaration, Set<ImportDeclaration>> entry : importMap.entrySet()) {
                if (entry.getKey().isStatic() != isStatic || !packageName.equals(entry.getKey().getName().asString())) continue;
                entry.getValue().add(new ImportDeclaration(qualifiedName, isStatic, false));
                break;
            }
        }

        public void visit(MarkerAnnotationExpr n, Map<ImportDeclaration, Set<ImportDeclaration>> importMap) {
            this.visitAnnotation((AnnotationExpr)n, importMap);
            super.visit(n, importMap);
        }

        public void visit(SingleMemberAnnotationExpr n, Map<ImportDeclaration, Set<ImportDeclaration>> importMap) {
            this.visitAnnotation((AnnotationExpr)n, importMap);
            super.visit(n, importMap);
        }

        public void visit(NormalAnnotationExpr n, Map<ImportDeclaration, Set<ImportDeclaration>> importMap) {
            this.visitAnnotation((AnnotationExpr)n, importMap);
            super.visit(n, importMap);
        }

        private void visitAnnotation(AnnotationExpr n, Map<ImportDeclaration, Set<ImportDeclaration>> importMap) {
            ResolvedAnnotationDeclaration resolvedType = CollectImportedTypesVisitor.wrapUnsolvedSymbolException(n, AnnotationExpr::resolve);
            this.matchTypeName(importMap, resolvedType.getQualifiedName(), false);
        }

        public void visit(MethodCallExpr n, Map<ImportDeclaration, Set<ImportDeclaration>> importMap) {
            ResolvedMethodDeclaration resolved = CollectImportedTypesVisitor.wrapUnsolvedSymbolException(n, MethodCallExpr::resolve);
            if (resolved.isStatic()) {
                this.matchTypeName(importMap, resolved.getQualifiedName(), true);
            }
            super.visit(n, importMap);
        }

        private static <T extends Node, R> R wrapUnsolvedSymbolException(T node, Function<T, R> func) {
            try {
                return func.apply(node);
            }
            catch (UnsolvedSymbolException ex) {
                if (node.getBegin().isPresent() && node.getEnd().isPresent()) {
                    throw Lint.atLineRange(((Position)node.getBegin().get()).line, ((Position)node.getEnd().get()).line, "UnsolvedSymbolException", ex.getMessage()).shortcut();
                }
                if (node.getBegin().isPresent()) {
                    throw Lint.atLine(((Position)node.getBegin().get()).line, "UnsolvedSymbolException", ex.getMessage()).shortcut();
                }
                if (node.getEnd().isPresent()) {
                    throw Lint.atLine(((Position)node.getEnd().get()).line, "UnsolvedSymbolException", ex.getMessage()).shortcut();
                }
                throw Lint.atUndefinedLine("UnsolvedSymbolException", ex.getMessage()).shortcut();
            }
        }
    }
}

