/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.glue.scalafmt;

import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.FormatterFunc;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import org.scalafmt.Scalafmt;
import org.scalafmt.Versions;
import org.scalafmt.config.ScalafmtConfig;
import org.scalafmt.config.ScalafmtConfig$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;

public class ScalafmtFormatterFunc
implements FormatterFunc.NeedsFile {
    private final ScalafmtConfig config;

    public ScalafmtFormatterFunc(FileSignature configSignature) throws Exception {
        if (configSignature.files().isEmpty()) {
            Method method = ScalafmtConfig$.MODULE$.getClass().getDeclaredMethod("default", new Class[0]);
            this.config = (ScalafmtConfig)method.invoke((Object)ScalafmtConfig$.MODULE$, new Object[0]);
        } else {
            File file = configSignature.getOnlyFile();
            String configStr = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
            this.config = (ScalafmtConfig)Scalafmt.parseHoconConfig((String)configStr).get();
        }
        String scalafmtLibraryVersion = Versions.version();
        if (!this.config.version().equals(scalafmtLibraryVersion)) {
            throw new IllegalArgumentException("Spotless is using " + scalafmtLibraryVersion + " but the config file declares " + this.config.version() + ". Both must match. Update the version declared in the plugin's settings and/or the config file.");
        }
    }

    @Override
    public String applyWithFile(String unix, File file) throws Exception {
        return Scalafmt.format((String)unix, (ScalafmtConfig)this.config, (Set)Set$.MODULE$.empty(), (String)file.getAbsolutePath()).get();
    }
}

