/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.LibPreconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

final class MoreIterables {
    private MoreIterables() {
    }

    static <T> List<T> toNullHostileList(Iterable<T> input) {
        ArrayList arrayList;
        LibPreconditions.requireElementsNonNull(input);
        if (input instanceof Collection) {
            Collection c = (Collection)input;
            arrayList = new ArrayList(c.size());
        } else {
            arrayList = new ArrayList();
        }
        ArrayList shallowCopy = arrayList;
        input.forEach(shallowCopy::add);
        return shallowCopy;
    }

    static <T extends Comparable<T>> List<T> toSortedSet(Iterable<T> raw) {
        return MoreIterables.toSortedSet(raw, Comparator.naturalOrder());
    }

    static <T> List<T> toSortedSet(Iterable<T> raw, Comparator<T> comparator) {
        List<T> toBeSorted = MoreIterables.toNullHostileList(raw);
        Collections.sort(toBeSorted, comparator);
        if (toBeSorted.size() > 1) {
            Iterator<T> iter = toBeSorted.iterator();
            T last = iter.next();
            while (iter.hasNext()) {
                T next = iter.next();
                if (comparator.compare(next, last) == 0) {
                    iter.remove();
                    continue;
                }
                last = next;
            }
        }
        return toBeSorted;
    }
}

