/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.pom;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.pom.SortPomCfg;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class SortPomStep
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String MAVEN_COORDINATE = "com.github.ekryd.sortpom:sortpom-sorter:";
    public static final String NAME = "sortPom";
    private final JarState.Promised jarState;
    private final SortPomCfg cfg;

    private SortPomStep(JarState.Promised jarState, SortPomCfg cfg) {
        this.jarState = jarState;
        this.cfg = cfg;
    }

    public static FormatterStep create(SortPomCfg cfg, Provisioner provisioner) {
        return FormatterStep.create(NAME, new SortPomStep(JarState.promise(() -> JarState.from(MAVEN_COORDINATE + cfg.version, provisioner)), cfg), SortPomStep::equalityState, State::createFormat);
    }

    private State equalityState() {
        return new State(this.jarState.get(), this.cfg);
    }

    private static class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final SortPomCfg cfg;
        private final JarState jarState;

        State(JarState jarState, SortPomCfg cfg) {
            this.jarState = jarState;
            this.cfg = cfg;
        }

        FormatterFunc createFormat() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
            Class<?> formatterFunc = this.jarState.getClassLoader().loadClass("com.diffplug.spotless.glue.pom.SortPomFormatterFunc");
            Constructor<?> constructor = formatterFunc.getConstructor(SortPomCfg.class);
            return (FormatterFunc)constructor.newInstance(this.cfg);
        }
    }
}

