/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.rdf;

import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.rdf.RdfFormatterConfig;
import com.diffplug.spotless.rdf.RdfFormatterFunc;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class RdfFormatterStep
implements Serializable {
    public static final String LATEST_TURTLE_FORMATTER_VERSION = "1.2.13";
    private static final long serialVersionUID = 1L;
    private static final String TURTLE_FORMATTER_COORDINATES = "de.atextor:turtle-formatter";
    private final JarState.Promised jarState;
    private final Map<String, String> turtleFormatterStyle;
    private final RdfFormatterConfig config;

    public static FormatterStep create(RdfFormatterConfig config, Map<String, String> turtleOptions, Provisioner provisioner) throws ClassNotFoundException {
        JarState.Promised jarState = JarState.promise(() -> JarState.from("de.atextor:turtle-formatter:" + config.getTurtleFormatterVersion(), provisioner));
        RdfFormatterStep step = new RdfFormatterStep(jarState, config, turtleOptions);
        return FormatterStep.create("RdfFormatter", step, RdfFormatterStep::state, RdfFormatterStep::formatterFunc);
    }

    public static State state(RdfFormatterStep step) {
        return new State(step.config, step.turtleFormatterStyle, step.jarState.get());
    }

    public static RdfFormatterFunc formatterFunc(State state) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return new RdfFormatterFunc(state);
    }

    public RdfFormatterStep(JarState.Promised jarState, RdfFormatterConfig config, Map<String, String> turtleFormatterStyle) {
        this.jarState = jarState;
        this.turtleFormatterStyle = turtleFormatterStyle;
        this.config = config;
    }

    public static class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final RdfFormatterConfig config;
        private final Map<String, String> turtleFormatterStyle;
        private final JarState jarState;

        public State(RdfFormatterConfig config, Map<String, String> turtleFormatterStyle, JarState jarState) {
            this.config = config;
            this.turtleFormatterStyle = new TreeMap<String, String>(turtleFormatterStyle == null ? Map.of() : turtleFormatterStyle);
            this.jarState = jarState;
        }

        public RdfFormatterConfig getConfig() {
            return this.config;
        }

        public Map<String, String> getTurtleFormatterStyle() {
            return this.turtleFormatterStyle;
        }

        public JarState getJarState() {
            return this.jarState;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof State)) {
                return false;
            }
            State state = (State)o;
            return Objects.equals(this.getConfig(), state.getConfig()) && Objects.equals(this.getTurtleFormatterStyle(), state.getTurtleFormatterStyle()) && Objects.equals(this.getJarState(), state.getJarState());
        }

        public int hashCode() {
            return Objects.hash(this.getConfig(), this.getTurtleFormatterStyle(), this.getJarState());
        }
    }
}

