/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.npm;

import com.diffplug.spotless.npm.PlatformInfo;
import java.io.File;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;

class NpmExecutableResolver {
    private NpmExecutableResolver() {
    }

    static String npmExecutableName() {
        String npmName = "npm";
        if (PlatformInfo.normalizedOS() == PlatformInfo.OS.WINDOWS) {
            npmName = npmName + ".cmd";
        }
        return npmName;
    }

    static Supplier<Optional<File>> systemProperty() {
        return () -> Optional.ofNullable(System.getProperty("npm.exec")).map(File::new);
    }

    static Supplier<Optional<File>> environmentNvmBin() {
        return () -> Optional.ofNullable(System.getenv("NVM_BIN")).map(File::new).map(binDir -> new File((File)binDir, NpmExecutableResolver.npmExecutableName())).filter(File::exists).filter(File::canExecute);
    }

    static Supplier<Optional<File>> environmentNvmSymlink() {
        return NpmExecutableResolver.pathListFromEnvironment("NVM_SYMLINK");
    }

    static Supplier<Optional<File>> environmentNodepath() {
        return NpmExecutableResolver.pathListFromEnvironment("NODE_PATH");
    }

    static Supplier<Optional<File>> environmentPath() {
        return NpmExecutableResolver.pathListFromEnvironment("PATH");
    }

    static Optional<File> tryFind() {
        return Stream.of(NpmExecutableResolver.systemProperty(), NpmExecutableResolver.environmentNvmBin(), NpmExecutableResolver.environmentNvmSymlink(), NpmExecutableResolver.environmentNodepath(), NpmExecutableResolver.environmentPath()).map(Supplier::get).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    private static Supplier<Optional<File>> pathListFromEnvironment(String environmentPathListName) {
        return () -> {
            String pathList = System.getenv(environmentPathListName);
            if (pathList != null) {
                return Arrays.stream(pathList.split(System.getProperty("path.separator", ":"))).map(File::new).map(dir -> dir.getName().equalsIgnoreCase("node_modules") ? dir.getParentFile() : dir).map(dir -> new File((File)dir, NpmExecutableResolver.npmExecutableName())).filter(File::exists).filter(File::canExecute).findFirst();
            }
            return Optional.empty();
        };
    }

    static String explainMessage() {
        return "Spotless tries to find your npm executable automatically. It looks for npm in the following places:\n- An executable referenced by the java system property 'npm.exec' - if such a system property exists.\n- The environment variable 'NVM_BIN' - if such an environment variable exists.\n- The environment variable 'NVM_SYMLINK' - if such an environment variable exists.\n- The environment variable 'NODE_PATH' - if such an environment variable exists.\n- In your 'PATH' environment variable\n\nIf autodiscovery fails for your system, try to set one of the environment variables correctly or\ntry setting the system property 'npm.exec' in the build process to override autodiscovery.";
    }
}

