/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.protobuf;

import com.diffplug.spotless.ForeignExe;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.ProcessRunner;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class BufStep {
    private final String version;
    @Nullable
    private final String pathToExe;

    public static String name() {
        return "buf";
    }

    public static String defaultVersion() {
        return "1.24.0";
    }

    private BufStep(String version, @Nullable String pathToExe) {
        this.version = version;
        this.pathToExe = pathToExe;
    }

    public static BufStep withVersion(String version) {
        return new BufStep(version, null);
    }

    public BufStep withPathToExe(String pathToExe) {
        return new BufStep(this.version, pathToExe);
    }

    public FormatterStep create() {
        return FormatterStep.createLazy(BufStep.name(), this::createState, State::toFunc);
    }

    private State createState() {
        String instructions = "https://docs.buf.build/installation";
        ForeignExe exeAbsPath = ForeignExe.nameAndVersion("buf", this.version).pathToExe(this.pathToExe).versionRegex(Pattern.compile("(\\S*)")).fixCantFind("Try following the instructions at " + instructions + ", or else tell Spotless where it is with {@code buf().pathToExe('path/to/executable')}");
        return new State(this, exeAbsPath);
    }

    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    static class State
    implements Serializable {
        private static final long serialVersionUID = -1825662356883926318L;
        final String version;
        final transient ForeignExe exe;
        @Nullable
        private transient List<String> args;

        State(BufStep step, ForeignExe exeAbsPath) {
            this.version = step.version;
            this.exe = Objects.requireNonNull(exeAbsPath);
        }

        String format(ProcessRunner runner, String input, File file) throws IOException, InterruptedException {
            if (this.args == null) {
                this.args = Arrays.asList(this.exe.confirmVersionAndGetAbsolutePath(), "format", file.getAbsolutePath());
            }
            return runner.exec(input.getBytes(StandardCharsets.UTF_8), this.args).assertExitZero(StandardCharsets.UTF_8);
        }

        FormatterFunc.Closeable toFunc() {
            ProcessRunner runner = new ProcessRunner();
            return FormatterFunc.Closeable.of(runner, this::format);
        }
    }
}

