/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.glue.ktlint;

import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.glue.ktlint.compat.KtLintCompat0Dot46Dot0Adapter;
import com.diffplug.spotless.glue.ktlint.compat.KtLintCompat0Dot47Dot0Adapter;
import com.diffplug.spotless.glue.ktlint.compat.KtLintCompat0Dot48Dot0Adapter;
import com.diffplug.spotless.glue.ktlint.compat.KtLintCompatAdapter;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class KtlintFormatterFunc
implements FormatterFunc.NeedsFile {
    private final Map<String, String> userData;
    private final boolean isScript;
    @NotNull
    private final KtLintCompatAdapter adapter;
    private final boolean useExperimental;
    private final FileSignature editorConfigPath;
    private final Map<String, Object> editorConfigOverrideMap;

    public KtlintFormatterFunc(String version, boolean isScript, boolean useExperimental, FileSignature editorConfigPath, Map<String, String> userData, Map<String, Object> editorConfigOverrideMap) {
        int minorVersion = Integer.parseInt(version.split("\\.")[1]);
        this.adapter = minorVersion >= 48 ? new KtLintCompat0Dot48Dot0Adapter() : (minorVersion == 47 ? new KtLintCompat0Dot47Dot0Adapter() : new KtLintCompat0Dot46Dot0Adapter());
        this.editorConfigPath = editorConfigPath;
        this.useExperimental = useExperimental;
        this.editorConfigOverrideMap = editorConfigOverrideMap;
        this.userData = userData;
        this.isScript = isScript;
    }

    @Override
    public String applyWithFile(String unix, File file) {
        Path absoluteEditorConfigPath = null;
        if (this.editorConfigPath != null) {
            absoluteEditorConfigPath = this.editorConfigPath.getOnlyFile().toPath();
        }
        return this.adapter.format(unix, file.toPath(), this.isScript, this.useExperimental, absoluteEditorConfigPath, this.userData, this.editorConfigOverrideMap);
    }
}

