/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.FormatterStepImpl;
import com.diffplug.spotless.ThrowingEx;
import java.io.File;
import java.util.Objects;

@FunctionalInterface
public interface FormatterFunc {
    public String apply(String var1) throws Exception;

    default public String apply(String unix, File file) throws Exception {
        return this.apply(unix);
    }

    public static FormatterFunc needsFile(NeedsFile needsFile) {
        return needsFile;
    }

    @FunctionalInterface
    public static interface NeedsFile
    extends FormatterFunc {
        public String applyWithFile(String var1, File var2) throws Exception;

        @Override
        default public String apply(String unix, File file) throws Exception {
            FormatterStepImpl.checkNotSentinel(file);
            return this.applyWithFile(unix, file);
        }

        @Override
        default public String apply(String unix) throws Exception {
            return this.apply(unix, Formatter.NO_FILE_SENTINEL);
        }
    }

    public static interface Closeable
    extends FormatterFunc,
    AutoCloseable {
        @Override
        public void close();

        public static Closeable ofDangerous(final AutoCloseable closeable, final FormatterFunc function) {
            Objects.requireNonNull(closeable, "closeable");
            Objects.requireNonNull(function, "function");
            return new Closeable(){

                @Override
                public void close() {
                    ThrowingEx.run(closeable::close);
                }

                @Override
                public String apply(String unix, File file) throws Exception {
                    return function.apply(unix, file);
                }

                @Override
                public String apply(String unix) throws Exception {
                    return function.apply(unix);
                }
            };
        }

        @Deprecated
        public static Closeable of(AutoCloseable closeable, FormatterFunc function) {
            return Closeable.ofDangerous(closeable, function);
        }

        public static <T extends AutoCloseable> Closeable of(final T resource, final ResourceFunc<T> function) {
            Objects.requireNonNull(resource, "resource");
            Objects.requireNonNull(function, "function");
            return new Closeable(){

                @Override
                public void close() {
                    ThrowingEx.run(resource::close);
                }

                @Override
                public String apply(String unix, File file) throws Exception {
                    return function.apply(resource, unix);
                }

                @Override
                public String apply(String unix) throws Exception {
                    return function.apply(resource, unix);
                }
            };
        }

        public static <T extends AutoCloseable> Closeable of(final T resource, final ResourceFuncNeedsFile<T> function) {
            Objects.requireNonNull(resource, "resource");
            Objects.requireNonNull(function, "function");
            return new Closeable(){

                @Override
                public void close() {
                    ThrowingEx.run(resource::close);
                }

                @Override
                public String apply(String unix, File file) throws Exception {
                    FormatterStepImpl.checkNotSentinel(file);
                    return function.apply(resource, unix, file);
                }

                @Override
                public String apply(String unix) throws Exception {
                    return this.apply(unix, Formatter.NO_FILE_SENTINEL);
                }
            };
        }

        @FunctionalInterface
        public static interface ResourceFuncNeedsFile<T extends AutoCloseable> {
            public String apply(T var1, String var2, File var3) throws Exception;
        }

        @FunctionalInterface
        public static interface ResourceFunc<T extends AutoCloseable> {
            public String apply(T var1, String var2) throws Exception;
        }
    }
}

