/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.npm;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.ProcessRunner;
import com.diffplug.spotless.ThrowingEx;
import com.diffplug.spotless.npm.FormattedPrinter;
import com.diffplug.spotless.npm.NodeServerLayout;
import com.diffplug.spotless.npm.NpmConfig;
import com.diffplug.spotless.npm.NpmFormatterStepLocations;
import com.diffplug.spotless.npm.NpmProcess;
import com.diffplug.spotless.npm.NpmResourceHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class NpmFormatterStepStateBase
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(NpmFormatterStepStateBase.class);
    private static final long serialVersionUID = 1460749955865959948L;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    protected final transient NodeServerLayout nodeServerLayout;
    public final NpmFormatterStepLocations locations;
    private final NpmConfig npmConfig;
    private final String stepName;

    protected NpmFormatterStepStateBase(String stepName, NpmConfig npmConfig, NpmFormatterStepLocations locations) throws IOException {
        this.stepName = Objects.requireNonNull(stepName);
        this.npmConfig = Objects.requireNonNull(npmConfig);
        this.locations = locations;
        this.nodeServerLayout = new NodeServerLayout(locations.buildDir(), stepName);
    }

    protected void prepareNodeServerLayout() throws IOException {
        NpmResourceHelper.assertDirectoryExists(this.nodeServerLayout.nodeModulesDir());
        NpmResourceHelper.writeUtf8StringToFile(this.nodeServerLayout.packageJsonFile(), this.npmConfig.getPackageJsonContent());
        NpmResourceHelper.writeUtf8StringToFile(this.nodeServerLayout.serveJsFile(), this.npmConfig.getServeScriptContent());
        if (this.npmConfig.getNpmrcContent() != null) {
            NpmResourceHelper.writeUtf8StringToFile(this.nodeServerLayout.npmrcFile(), this.npmConfig.getNpmrcContent());
        } else {
            NpmResourceHelper.deleteFileIfExists(this.nodeServerLayout.npmrcFile());
        }
    }

    protected void prepareNodeServer() throws IOException {
        FormattedPrinter.SYSOUT.print("running npm install", new Object[0]);
        this.runNpmInstall(this.nodeServerLayout.nodeModulesDir());
        FormattedPrinter.SYSOUT.print("npm install finished", new Object[0]);
    }

    private void runNpmInstall(File npmProjectDir) throws IOException {
        new NpmProcess(npmProjectDir, this.locations.npmExecutable(), this.locations.nodeExecutable()).install();
    }

    protected void assertNodeServerDirReady() throws IOException {
        if (this.needsPrepareNodeServerLayout()) {
            this.prepareNodeServerLayout();
        }
        if (this.needsPrepareNodeServer()) {
            this.prepareNodeServer();
        }
    }

    protected boolean needsPrepareNodeServer() {
        return !this.nodeServerLayout.isNodeModulesPrepared();
    }

    protected boolean needsPrepareNodeServerLayout() {
        return !this.nodeServerLayout.isLayoutPrepared();
    }

    protected ServerProcessInfo npmRunServer() throws ServerStartException, IOException {
        this.assertNodeServerDirReady();
        ProcessRunner.LongRunningProcess server = null;
        try {
            File serverPortFile = new File(this.nodeServerLayout.nodeModulesDir(), "server.port");
            NpmResourceHelper.deleteFileIfExists(serverPortFile);
            server = new NpmProcess(this.nodeServerLayout.nodeModulesDir(), this.locations.npmExecutable(), this.locations.nodeExecutable()).start();
            try {
                NpmResourceHelper.awaitReadableFile(serverPortFile, Duration.ofSeconds(60L));
            }
            catch (TimeoutException timeoutException) {
                try {
                    if (server.isAlive()) {
                        server.destroyForcibly();
                        server.waitFor();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw timeoutException;
            }
            String serverPort = NpmResourceHelper.readUtf8StringFromFile(serverPortFile).trim();
            return new ServerProcessInfo(server, serverPort, serverPortFile);
        }
        catch (IOException | TimeoutException e) {
            throw new ServerStartException("Starting server failed." + (server != null ? "\n\nProcess result:\n" + ThrowingEx.get(server::result) : ""), e);
        }
    }

    protected static String replaceDevDependencies(String template, Map<String, String> devDependencies) {
        StringBuilder builder = new StringBuilder();
        Iterator<Map.Entry<String, String>> entryIter = devDependencies.entrySet().iterator();
        while (entryIter.hasNext()) {
            Map.Entry<String, String> entry = entryIter.next();
            builder.append("\t\t\"");
            builder.append(entry.getKey());
            builder.append("\": \"");
            builder.append(entry.getValue());
            builder.append("\"");
            if (!entryIter.hasNext()) continue;
            builder.append(",\n");
        }
        return NpmFormatterStepStateBase.replacePlaceholders(template, Collections.singletonMap("devDependencies", builder.toString()));
    }

    private static String replacePlaceholders(String template, Map<String, String> replacements) {
        String result = template;
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            result = result.replaceAll("\\Q${" + entry.getKey() + "}\\E", entry.getValue());
        }
        return result;
    }

    public abstract FormatterFunc createFormatterFunc();

    protected static class ServerStartException
    extends RuntimeException {
        private static final long serialVersionUID = -8803977379866483002L;

        public ServerStartException(String message, Throwable cause) {
            super(cause);
        }
    }

    protected static class ServerProcessInfo
    implements AutoCloseable {
        private final Process server;
        private final String serverPort;
        private final File serverPortFile;

        public ServerProcessInfo(Process server, String serverPort, File serverPortFile) {
            this.server = server;
            this.serverPort = serverPort;
            this.serverPortFile = serverPortFile;
        }

        public String getBaseUrl() {
            return "http://127.0.0.1:" + this.serverPort;
        }

        @Override
        public void close() throws Exception {
            try {
                boolean ended;
                logger.trace("Closing npm server in directory <{}> and port <{}>", (Object)this.serverPortFile.getParent(), (Object)this.serverPort);
                if (this.server.isAlive() && !(ended = this.server.waitFor(5L, TimeUnit.SECONDS))) {
                    logger.info("Force-Closing npm server in directory <{}> and port <{}>", (Object)this.serverPortFile.getParent(), (Object)this.serverPort);
                    this.server.destroyForcibly().waitFor();
                    logger.trace("Force-Closing npm server in directory <{}> and port <{}> -- Finished", (Object)this.serverPortFile.getParent(), (Object)this.serverPort);
                }
            }
            finally {
                NpmResourceHelper.deleteFileIfExists(this.serverPortFile);
            }
        }
    }
}

