/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.npm;

import com.diffplug.spotless.ThrowingEx;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;

class NodeServerLayout {
    private final File nodeModulesDir;
    private final File packageJsonFile;
    private final File serveJsFile;
    private final File npmrcFile;

    NodeServerLayout(File buildDir, String stepName) {
        this.nodeModulesDir = new File(buildDir, "spotless-node-modules-" + stepName);
        this.packageJsonFile = new File(this.nodeModulesDir, "package.json");
        this.serveJsFile = new File(this.nodeModulesDir, "serve.js");
        this.npmrcFile = new File(this.nodeModulesDir, ".npmrc");
    }

    File nodeModulesDir() {
        return this.nodeModulesDir;
    }

    File packageJsonFile() {
        return this.packageJsonFile;
    }

    File serveJsFile() {
        return this.serveJsFile;
    }

    public File npmrcFile() {
        return this.npmrcFile;
    }

    static File getBuildDirFromNodeModulesDir(File nodeModulesDir) {
        return nodeModulesDir.getParentFile();
    }

    public boolean isLayoutPrepared() {
        if (!this.nodeModulesDir().isDirectory()) {
            return false;
        }
        if (!this.packageJsonFile().isFile()) {
            return false;
        }
        return this.serveJsFile().isFile();
    }

    public boolean isNodeModulesPrepared() {
        Path nodeModulesInstallDirPath = new File(this.nodeModulesDir(), "node_modules").toPath();
        if (!Files.isDirectory(nodeModulesInstallDirPath, new LinkOption[0])) {
            return false;
        }
        return ThrowingEx.get(() -> {
            try (Stream<Path> entries = Files.list(nodeModulesInstallDirPath);){
                Boolean bl = entries.findFirst().isPresent();
                return bl;
            }
        });
    }
}

