/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.glue.ktlint;

import com.diffplug.spotless.FormatterFunc;
import com.pinterest.ktlint.core.KtLint;
import com.pinterest.ktlint.core.LintError;
import com.pinterest.ktlint.core.RuleSet;
import com.pinterest.ktlint.core.api.DefaultEditorConfigProperties;
import com.pinterest.ktlint.core.api.EditorConfigOverride;
import com.pinterest.ktlint.core.api.UsesEditorConfigProperties;
import com.pinterest.ktlint.ruleset.experimental.ExperimentalRuleSetProvider;
import com.pinterest.ktlint.ruleset.standard.StandardRuleSetProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;

public class KtlintFormatterFunc
implements FormatterFunc.NeedsFile {
    private final List<RuleSet> rulesets = new ArrayList<RuleSet>();
    private final Map<String, String> userData;
    private final Function2<? super LintError, ? super Boolean, Unit> formatterCallback;
    private final boolean isScript;
    @NotNull
    private final EditorConfigOverride editorConfigOverride;

    public KtlintFormatterFunc(boolean isScript, boolean useExperimental, Map<String, String> userData, Map<String, Object> editorConfigOverrideMap) {
        this.rulesets.add(new StandardRuleSetProvider().get());
        if (useExperimental) {
            this.rulesets.add(new ExperimentalRuleSetProvider().get());
        }
        this.userData = userData;
        this.formatterCallback = new FormatterCallback();
        this.isScript = isScript;
        this.editorConfigOverride = editorConfigOverrideMap.isEmpty() ? EditorConfigOverride.Companion.getEmptyEditorConfigOverride() : this.createEditorConfigOverride(editorConfigOverrideMap);
    }

    private EditorConfigOverride createEditorConfigOverride(Map<String, Object> editorConfigOverrideMap) {
        Stream ruleProperties = this.rulesets.stream().flatMap(ruleSet -> Arrays.stream(ruleSet.getRules())).filter(rule -> rule instanceof UsesEditorConfigProperties).flatMap(rule -> ((UsesEditorConfigProperties)rule).getEditorConfigProperties().stream());
        Map<String, UsesEditorConfigProperties.EditorConfigProperty> supportedProperties = Stream.concat(ruleProperties, DefaultEditorConfigProperties.INSTANCE.getEditorConfigProperties().stream()).distinct().collect(Collectors.toMap(property -> property.getType().getName(), property -> property));
        Pair[] properties = (Pair[])editorConfigOverrideMap.entrySet().stream().map(entry -> {
            UsesEditorConfigProperties.EditorConfigProperty property = (UsesEditorConfigProperties.EditorConfigProperty)supportedProperties.get(entry.getKey());
            if (property != null) {
                return new Pair((Object)property, entry.getValue());
            }
            return null;
        }).filter(Objects::nonNull).toArray(Pair[]::new);
        return EditorConfigOverride.Companion.from(properties);
    }

    @Override
    public String applyWithFile(String unix, File file) throws Exception {
        return KtLint.INSTANCE.format(new KtLint.ExperimentalParams(file.getName(), unix, this.rulesets, this.userData, this.formatterCallback, this.isScript, null, false, this.editorConfigOverride, false));
    }

    static class FormatterCallback
    implements Function2<LintError, Boolean, Unit> {
        FormatterCallback() {
        }

        public Unit invoke(LintError lint, Boolean corrected) {
            if (!corrected.booleanValue()) {
                throw new AssertionError((Object)("Error on line: " + lint.getLine() + ", column: " + lint.getCol() + "\nrule: " + lint.getRuleId() + "\n" + lint.getDetail()));
            }
            return null;
        }
    }
}

