/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.glue.diktat;

import com.diffplug.spotless.FormatterFunc;
import com.pinterest.ktlint.core.KtLint;
import com.pinterest.ktlint.core.LintError;
import com.pinterest.ktlint.core.RuleSet;
import com.pinterest.ktlint.core.api.EditorConfigOverride;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import org.cqfn.diktat.ruleset.rules.DiktatRuleSetProvider;

public class DiktatFormatterFunc
implements FormatterFunc.NeedsFile {
    private final List<RuleSet> rulesets;
    private final Function2<? super LintError, ? super Boolean, Unit> formatterCallback;
    private final boolean isScript;
    private final ArrayList<LintError> errors = new ArrayList();

    public DiktatFormatterFunc(boolean isScript) {
        this.rulesets = Collections.singletonList(new DiktatRuleSetProvider().get());
        this.formatterCallback = new FormatterCallback(this.errors);
        this.isScript = isScript;
    }

    @Override
    public String applyWithFile(String unix, File file) throws Exception {
        this.errors.clear();
        String result = KtLint.INSTANCE.format(new KtLint.ExperimentalParams(file.getAbsolutePath(), unix, this.rulesets, Collections.emptyMap(), this.formatterCallback, this.isScript, null, false, new EditorConfigOverride(), false));
        if (!this.errors.isEmpty()) {
            StringBuilder error = new StringBuilder();
            error.append("There are ").append(this.errors.size()).append(" unfixed errors:");
            for (LintError er : this.errors) {
                error.append(System.lineSeparator()).append("Error on line: ").append(er.getLine()).append(", column: ").append(er.getCol()).append(" cannot be fixed automatically").append(System.lineSeparator()).append(er.getDetail());
            }
            throw new AssertionError(error);
        }
        return result;
    }

    static class FormatterCallback
    implements Function2<LintError, Boolean, Unit> {
        private final ArrayList<LintError> errors;

        FormatterCallback(ArrayList<LintError> errors) {
            this.errors = errors;
        }

        public Unit invoke(LintError lintError, Boolean corrected) {
            if (!corrected.booleanValue()) {
                this.errors.add(lintError);
            }
            return null;
        }
    }
}

