/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.FormatExceptionPolicy;
import com.diffplug.spotless.FormatExceptionPolicyLegacy;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.NoLambda;
import com.diffplug.spotless.ThrowingEx;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class FormatExceptionPolicyStrict
extends NoLambda.EqualityBasedOnSerialization
implements FormatExceptionPolicy {
    private static final long serialVersionUID = 1L;
    private final Set<String> excludeSteps = new TreeSet<String>();
    private final Set<String> excludePaths = new TreeSet<String>();

    public void excludeStep(String stepName) {
        this.excludeSteps.add(Objects.requireNonNull(stepName));
    }

    public void excludePath(String relativePath) {
        this.excludePaths.add(Objects.requireNonNull(relativePath));
    }

    @Override
    public void handleError(Throwable e, FormatterStep step, String relativePath) {
        Objects.requireNonNull(e, "e");
        Objects.requireNonNull(step, "step");
        Objects.requireNonNull(relativePath, "relativePath");
        if (this.excludeSteps.contains(step.getName())) {
            FormatExceptionPolicyLegacy.warning(e, step, relativePath);
        } else if (this.excludePaths.contains(relativePath)) {
            FormatExceptionPolicyLegacy.warning(e, step, relativePath);
        } else {
            FormatExceptionPolicyLegacy.error(e, step, relativePath);
            throw ThrowingEx.asRuntimeRethrowError(e);
        }
    }
}

