/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.sql.dbeaver;

import com.diffplug.spotless.annotations.Internal;
import com.diffplug.spotless.sql.dbeaver.DBPKeywordType;
import com.diffplug.spotless.sql.dbeaver.DBeaverSQLFormatterConfiguration;
import com.diffplug.spotless.sql.dbeaver.FormatterToken;
import com.diffplug.spotless.sql.dbeaver.KeywordCase;
import com.diffplug.spotless.sql.dbeaver.Pair;
import com.diffplug.spotless.sql.dbeaver.SQLDialect;
import com.diffplug.spotless.sql.dbeaver.SQLTokensParser;
import com.diffplug.spotless.sql.dbeaver.TokenType;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

@Internal
public class SQLTokenizedFormatter {
    private static final String[] JOIN_BEGIN = new String[]{"LEFT", "RIGHT", "INNER", "OUTER", "JOIN"};
    private static final SQLDialect sqlDialect = SQLDialect.INSTANCE;
    private DBeaverSQLFormatterConfiguration formatterCfg;
    private List<Boolean> functionBracket = new ArrayList<Boolean>();
    private List<String> statementDelimiters = new ArrayList<String>(2);

    public SQLTokenizedFormatter(DBeaverSQLFormatterConfiguration formatterCfg) {
        this.formatterCfg = formatterCfg;
    }

    public String format(String argSql) {
        this.statementDelimiters.add(this.formatterCfg.getStatementDelimiter());
        SQLTokensParser fParser = new SQLTokensParser();
        this.functionBracket.clear();
        boolean isSqlEndsWithNewLine = false;
        if (argSql.endsWith("\n")) {
            isSqlEndsWithNewLine = true;
        }
        List<FormatterToken> list = fParser.parse(argSql);
        list = this.format(list);
        StringBuilder after = new StringBuilder(argSql.length() + 20);
        for (FormatterToken token : list) {
            after.append(token.getString());
        }
        if (isSqlEndsWithNewLine) {
            after.append(SQLTokenizedFormatter.getDefaultLineSeparator());
        }
        return after.toString();
    }

    private List<FormatterToken> format(List<FormatterToken> argList) {
        int index;
        int index2;
        if (argList.isEmpty()) {
            return argList;
        }
        FormatterToken token = argList.get(0);
        if (token.getType() == TokenType.SPACE) {
            argList.remove(0);
            if (argList.isEmpty()) {
                return argList;
            }
        }
        if ((token = argList.get(argList.size() - 1)).getType() == TokenType.SPACE) {
            argList.remove(argList.size() - 1);
            if (argList.isEmpty()) {
                return argList;
            }
        }
        KeywordCase keywordCase = this.formatterCfg.getKeywordCase();
        for (FormatterToken anArgList : argList) {
            token = anArgList;
            if (token.getType() != TokenType.KEYWORD) continue;
            token.setString(keywordCase.transform(token.getString()));
        }
        for (index2 = argList.size() - 1; index2 >= 1; --index2) {
            token = argList.get(index2);
            FormatterToken prevToken = argList.get(index2 - 1);
            if (token.getType() == TokenType.SPACE && (prevToken.getType() == TokenType.SYMBOL || prevToken.getType() == TokenType.COMMENT)) {
                argList.remove(index2);
                continue;
            }
            if ((token.getType() == TokenType.SYMBOL || token.getType() == TokenType.COMMENT) && prevToken.getType() == TokenType.SPACE) {
                argList.remove(index2 - 1);
                continue;
            }
            if (token.getType() != TokenType.SPACE) continue;
            token.setString(" ");
        }
        for (index2 = 0; index2 < argList.size() - 2; ++index2) {
            FormatterToken t0 = argList.get(index2);
            FormatterToken t1 = argList.get(index2 + 1);
            FormatterToken t2 = argList.get(index2 + 2);
            String tokenString = t0.getString().toUpperCase(Locale.ENGLISH);
            String token2String = t2.getString().toUpperCase(Locale.ENGLISH);
            if (t0.getType() == TokenType.KEYWORD && t1.getType() == TokenType.SPACE && t2.getType() == TokenType.KEYWORD && ((tokenString.equals("ORDER") || tokenString.equals("GROUP") || tokenString.equals("CONNECT")) && token2String.equals("BY") || tokenString.equals("START") && token2String.equals("WITH"))) {
                t0.setString(t0.getString() + " " + t2.getString());
                argList.remove(index2 + 1);
                argList.remove(index2 + 1);
            }
            if (!tokenString.equals("(") || !t1.getString().equals("+") || !token2String.equals(")")) continue;
            t0.setString("(+)");
            argList.remove(index2 + 1);
            argList.remove(index2 + 1);
        }
        int indent = 0;
        ArrayList<Integer> bracketIndent = new ArrayList<Integer>();
        FormatterToken prev = new FormatterToken(TokenType.SPACE, " ");
        boolean encounterBetween = false;
        for (index = 0; index < argList.size(); ++index) {
            token = argList.get(index);
            String tokenString = token.getString().toUpperCase(Locale.ENGLISH);
            if (token.getType() == TokenType.SYMBOL) {
                if (tokenString.equals("(")) {
                    this.functionBracket.add(this.isFunction(prev.getString()) ? Boolean.TRUE : Boolean.FALSE);
                    bracketIndent.add(indent);
                    index += this.insertReturnAndIndent(argList, index + 1, ++indent);
                } else if (tokenString.equals(")") && !bracketIndent.isEmpty() && !this.functionBracket.isEmpty()) {
                    indent = (Integer)bracketIndent.remove(bracketIndent.size() - 1);
                    index += this.insertReturnAndIndent(argList, index, indent);
                    this.functionBracket.remove(this.functionBracket.size() - 1);
                } else if (tokenString.equals(",")) {
                    index += this.insertReturnAndIndent(argList, index + 1, indent);
                } else if (this.statementDelimiters.contains(tokenString)) {
                    indent = 0;
                    index += this.insertReturnAndIndent(argList, index, indent);
                }
            } else if (token.getType() == TokenType.KEYWORD) {
                switch (tokenString) {
                    case "DELETE": 
                    case "SELECT": 
                    case "UPDATE": 
                    case "INSERT": 
                    case "INTO": 
                    case "CREATE": 
                    case "DROP": 
                    case "TRUNCATE": 
                    case "TABLE": 
                    case "CASE": {
                        index += this.insertReturnAndIndent(argList, index + 1, ++indent);
                        break;
                    }
                    case "FROM": 
                    case "WHERE": 
                    case "SET": 
                    case "START WITH": 
                    case "CONNECT BY": 
                    case "ORDER BY": 
                    case "GROUP BY": 
                    case "HAVING": {
                        index += this.insertReturnAndIndent(argList, index, indent - 1);
                        index += this.insertReturnAndIndent(argList, index + 1, indent);
                        break;
                    }
                    case "LEFT": 
                    case "RIGHT": 
                    case "INNER": 
                    case "OUTER": 
                    case "JOIN": {
                        if (!this.isJoinStart(argList, index)) break;
                        index += this.insertReturnAndIndent(argList, index, indent - 1);
                        break;
                    }
                    case "VALUES": 
                    case "END": {
                        index += this.insertReturnAndIndent(argList, index, --indent);
                        break;
                    }
                    case "OR": 
                    case "WHEN": 
                    case "ELSE": {
                        index += this.insertReturnAndIndent(argList, index, indent);
                        break;
                    }
                    case "ON": {
                        index += this.insertReturnAndIndent(argList, index + 1, indent);
                        break;
                    }
                    case "USING": {
                        index += this.insertReturnAndIndent(argList, index, indent + 1);
                        break;
                    }
                    case "TOP": {
                        index += this.insertReturnAndIndent(argList, index, indent);
                        if (argList.size() >= index + 3) break;
                        index += this.insertReturnAndIndent(argList, index + 3, indent);
                        break;
                    }
                    case "UNION": 
                    case "INTERSECT": 
                    case "EXCEPT": {
                        index += this.insertReturnAndIndent(argList, index, indent -= 2);
                        ++indent;
                        break;
                    }
                    case "BETWEEN": {
                        encounterBetween = true;
                        break;
                    }
                    case "AND": {
                        if (!encounterBetween) {
                            index += this.insertReturnAndIndent(argList, index, indent);
                        }
                        encounterBetween = false;
                        break;
                    }
                }
            } else if (token.getType() == TokenType.COMMENT) {
                String[] slComments;
                boolean isComment = false;
                for (String slc : slComments = sqlDialect.getSingleLineComments()) {
                    if (!token.getString().startsWith(slc)) continue;
                    isComment = true;
                    break;
                }
                if (!isComment) {
                    Pair<String, String> mlComments = sqlDialect.getMultiLineComments();
                    if (token.getString().startsWith(mlComments.getFirst())) {
                        index += this.insertReturnAndIndent(argList, index + 1, indent);
                    }
                }
            } else if (token.getType() == TokenType.COMMAND) {
                indent = 0;
                if (index > 0) {
                    index += this.insertReturnAndIndent(argList, index, 0);
                }
                index += this.insertReturnAndIndent(argList, index + 1, 0);
            } else if (token.getType() == TokenType.NAME && index > 0 && argList.get(index - 1).getType() == TokenType.COMMENT) {
                index += this.insertReturnAndIndent(argList, index, indent);
            } else if (this.statementDelimiters.contains(tokenString)) {
                indent = 0;
                index += this.insertReturnAndIndent(argList, index + 1, indent);
            }
            prev = token;
        }
        for (index = argList.size() - 1; index >= 4; --index) {
            if (index >= argList.size()) continue;
            FormatterToken t0 = argList.get(index);
            FormatterToken t1 = argList.get(index - 1);
            FormatterToken t2 = argList.get(index - 2);
            FormatterToken t3 = argList.get(index - 3);
            FormatterToken t4 = argList.get(index - 4);
            if (!t4.getString().equals("(") || !t3.getString().trim().isEmpty() || !t1.getString().trim().isEmpty() || !t0.getString().equalsIgnoreCase(")")) continue;
            t4.setString(t4.getString() + t2.getString() + t0.getString());
            argList.remove(index);
            argList.remove(index - 1);
            argList.remove(index - 2);
            argList.remove(index - 3);
        }
        for (index = 1; index < argList.size(); ++index) {
            prev = argList.get(index - 1);
            token = argList.get(index);
            if (prev.getType() == TokenType.SPACE || token.getType() == TokenType.SPACE || token.getString().startsWith("(") || token.getString().equals(",") || this.statementDelimiters.contains(token.getString()) || this.isFunction(prev.getString()) && token.getString().equals("(") || token.getType() == TokenType.VALUE && prev.getType() == TokenType.NAME || token.getType() == TokenType.SYMBOL && SQLTokenizedFormatter.isEmbeddedToken(token) || prev.getType() == TokenType.SYMBOL && SQLTokenizedFormatter.isEmbeddedToken(prev) || token.getType() == TokenType.SYMBOL && prev.getType() == TokenType.SYMBOL || prev.getType() == TokenType.COMMENT) continue;
            argList.add(index, new FormatterToken(TokenType.SPACE, " "));
        }
        return argList;
    }

    private static boolean isEmbeddedToken(FormatterToken token) {
        return ":".equals(token.getString()) || ".".equals(token.getString());
    }

    private boolean isJoinStart(List<FormatterToken> argList, int index) {
        FormatterToken token;
        int i;
        if (!SQLTokenizedFormatter.contains(JOIN_BEGIN, argList.get(index).getString())) {
            return false;
        }
        for (i = index - 1; i >= 0; --i) {
            token = argList.get(i);
            if (token.getType() == TokenType.SPACE) continue;
            if (!SQLTokenizedFormatter.contains(JOIN_BEGIN, token.getString())) break;
            return false;
        }
        for (i = index; i < argList.size(); ++i) {
            token = argList.get(i);
            if (token.getType() == TokenType.SPACE) continue;
            if (token.getString().equals("JOIN")) {
                return true;
            }
            if (SQLTokenizedFormatter.contains(JOIN_BEGIN, token.getString())) continue;
            return false;
        }
        return false;
    }

    private boolean isFunction(String name) {
        return sqlDialect.getKeywordType(name) == DBPKeywordType.FUNCTION;
    }

    private static String getDefaultLineSeparator() {
        return System.getProperty("line.separator", "\n");
    }

    private int insertReturnAndIndent(List<FormatterToken> argList, int argIndex, int argIndent) {
        if (this.functionBracket.contains(Boolean.TRUE)) {
            return 0;
        }
        try {
            FormatterToken token;
            String defaultLineSeparator = SQLTokenizedFormatter.getDefaultLineSeparator();
            StringBuilder s = new StringBuilder(defaultLineSeparator);
            for (int index = 0; index < argIndent; ++index) {
                s.append(this.formatterCfg.getIndentString());
            }
            if (argIndex > 0) {
                FormatterToken token2 = argList.get(argIndex);
                FormatterToken prevToken = argList.get(argIndex - 1);
                if (token2.getType() == TokenType.COMMENT && SQLTokenizedFormatter.isCommentLine(sqlDialect, token2.getString()) && prevToken.getType() != TokenType.END) {
                    s.setCharAt(0, ' ');
                    s.setLength(1);
                    String comment = token2.getString();
                    String withoutTrailingWhitespace = comment.replaceFirst("\\s*$", "");
                    token2.setString(withoutTrailingWhitespace);
                }
            }
            if ((token = argList.get(argIndex)).getType() == TokenType.SPACE) {
                token.setString(s.toString());
                return 0;
            }
            boolean isDelimiter = this.statementDelimiters.contains(token.getString().toUpperCase(Locale.ENGLISH));
            if (!isDelimiter && (token = argList.get(argIndex - 1)).getType() == TokenType.SPACE) {
                token.setString(s.toString());
                return 0;
            }
            if (isDelimiter) {
                if (argList.size() > argIndex + 1) {
                    String string = s.toString();
                    argList.add(argIndex + 1, new FormatterToken(TokenType.SPACE, string + string));
                }
            } else {
                argList.add(argIndex, new FormatterToken(TokenType.SPACE, s.toString()));
            }
            return 1;
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            return 0;
        }
    }

    private static boolean isCommentLine(SQLDialect dialect, String line) {
        for (String slc : dialect.getSingleLineComments()) {
            if (!line.startsWith(slc)) continue;
            return true;
        }
        return false;
    }

    private static <OBJECT_TYPE> boolean contains(OBJECT_TYPE[] array, OBJECT_TYPE value) {
        if (array == null || array.length == 0) {
            return false;
        }
        for (OBJECT_TYPE anArray : array) {
            if (!Objects.equals(value, anArray)) continue;
            return true;
        }
        return false;
    }
}

