/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.npm;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

class FileFinder {
    private final List<Supplier<Optional<File>>> fileCandidateFinders;

    private FileFinder(Builder builder) {
        this.fileCandidateFinders = Collections.unmodifiableList(new ArrayList(builder.candidateFinders));
    }

    static Builder finderForFilename(String fileName) {
        return new Builder(fileName, null);
    }

    static Builder finderForExecutableFilename(String fileName) {
        return new Builder(fileName, true);
    }

    Optional<File> tryFind() {
        return this.fileCandidateFinders.stream().map(Supplier::get).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    private static class CandidateInFolder
    implements Supplier<Optional<File>> {
        private final File folder;
        private final String fileName;
        private final Predicate<File> additionalFilter;

        public CandidateInFolder(File folder, String fileName, Predicate<File> additionalFilter) {
            this.folder = folder;
            this.fileName = fileName;
            this.additionalFilter = additionalFilter == null ? AnyFileFilter.any() : additionalFilter;
        }

        @Override
        public Optional<File> get() {
            return Optional.of(this.folder).filter(File::exists).filter(File::isDirectory).map(folder -> new File((File)folder, this.fileName)).filter(File::exists).filter(this.additionalFilter);
        }
    }

    private static class CandidateOnSystemPropertyVar
    implements Supplier<Optional<File>> {
        private final String systemProperty;
        private final Predicate<File> additionalFilter;

        public CandidateOnSystemPropertyVar(String systemProperty, Predicate<File> additionalFilter) {
            this.systemProperty = systemProperty;
            this.additionalFilter = additionalFilter == null ? AnyFileFilter.any() : additionalFilter;
        }

        @Override
        public Optional<File> get() {
            return Optional.ofNullable(System.getProperty(this.systemProperty)).map(File::new).filter(File::exists).filter(this.additionalFilter);
        }
    }

    private static class CandidateOnPathListEnvironmentVar
    implements Supplier<Optional<File>> {
        private final String environmentVar;
        private final String fileName;
        private final Function<File, File> fileTransformer;
        private final Predicate<File> additionalFilter;

        public CandidateOnPathListEnvironmentVar(String environmentVar, String fileName, Function<File, File> fileTransformer, Predicate<File> additionalFilter) {
            this.environmentVar = environmentVar;
            this.fileName = fileName;
            this.fileTransformer = fileTransformer;
            this.additionalFilter = additionalFilter;
        }

        @Override
        public Optional<File> get() {
            String pathList = System.getenv(this.environmentVar);
            if (pathList != null) {
                return Arrays.stream(pathList.split(System.getProperty("path.separator", ":"))).map(File::new).filter(File::exists).map(this.fileTransformer).map(dir -> new File((File)dir, this.fileName)).filter(File::exists).filter(this.additionalFilter).findFirst();
            }
            return Optional.empty();
        }
    }

    private static class CandidateOnSinglePathEnvironmentVar
    implements Supplier<Optional<File>> {
        private final String environmentVar;
        private final String fileName;
        private final Predicate<File> additionalFilters;

        public CandidateOnSinglePathEnvironmentVar(String environmentVar, String fileName, Predicate<File> additionalFilter) {
            this.environmentVar = environmentVar;
            this.fileName = fileName;
            this.additionalFilters = additionalFilter == null ? AnyFileFilter.any() : additionalFilter;
        }

        @Override
        public Optional<File> get() {
            return Optional.ofNullable(this.environmentVar).map(File::new).map(file -> new File((File)file, this.fileName)).filter(File::exists).filter(this.additionalFilters);
        }
    }

    private static class AnyFileFilter
    implements Predicate<File> {
        private AnyFileFilter() {
        }

        @Override
        public boolean test(File file) {
            return true;
        }

        static AnyFileFilter any() {
            return new AnyFileFilter();
        }
    }

    private static class FileIsExecutableFilter
    implements Predicate<File> {
        private FileIsExecutableFilter() {
        }

        @Override
        public boolean test(File file) {
            return file.canExecute();
        }

        static Predicate<File> executable() {
            return new FileIsExecutableFilter();
        }

        static Predicate<File> executable(Boolean executable) {
            if (executable == null) {
                return AnyFileFilter.any();
            }
            if (executable.booleanValue()) {
                return FileIsExecutableFilter.executable();
            }
            return FileIsExecutableFilter.executable().negate();
        }
    }

    static class Builder {
        private final String fileName;
        private final Boolean executable;
        private final List<Supplier<Optional<File>>> candidateFinders = new ArrayList<Supplier<Optional<File>>>();

        Builder(String fileName, Boolean executable) {
            this.fileName = Objects.requireNonNull(fileName);
            this.executable = executable;
        }

        public Builder candidateEnvironmentPath(String environmentVar) {
            this.candidateFinders.add(new CandidateOnSinglePathEnvironmentVar(environmentVar, this.fileName, FileIsExecutableFilter.executable(this.executable)));
            return this;
        }

        public Builder candidateEnvironmentPathList(String environmentVar, Function<File, File> fileTransformer) {
            this.candidateFinders.add(new CandidateOnPathListEnvironmentVar(environmentVar, this.fileName, fileTransformer, FileIsExecutableFilter.executable(this.executable)));
            return this;
        }

        public Builder candidateSystemProperty(String systemProperty) {
            this.candidateFinders.add(new CandidateOnSystemPropertyVar(systemProperty, FileIsExecutableFilter.executable(this.executable)));
            return this;
        }

        public Builder candidateFileInFolder(File folder) {
            this.candidateFinders.add(new CandidateInFolder(folder, this.fileName, FileIsExecutableFilter.executable(this.executable)));
            return this;
        }

        public FileFinder build() {
            return new FileFinder(this);
        }
    }
}

