/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.kotlin;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.ThrowingEx;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class KtLintStep {
    private static final String DEFAULT_VERSION = "0.6.1";
    static final String NAME = "ktlint";
    static final String MAVEN_COORDINATE = "com.github.shyiko:ktlint:";

    private KtLintStep() {
    }

    public static FormatterStep create(Provisioner provisioner) {
        return KtLintStep.create(KtLintStep.defaultVersion(), provisioner);
    }

    public static FormatterStep create(String version, Provisioner provisioner) {
        return KtLintStep.create(version, provisioner, false);
    }

    public static FormatterStep createForScript(String version, Provisioner provisioner) {
        return KtLintStep.create(version, provisioner, true);
    }

    private static FormatterStep create(String version, Provisioner provisioner, boolean isScript) {
        Objects.requireNonNull(version, "version");
        Objects.requireNonNull(provisioner, "provisioner");
        return FormatterStep.createLazy(NAME, () -> new State(version, provisioner, isScript), State::createFormat);
    }

    public static String defaultVersion() {
        return DEFAULT_VERSION;
    }

    static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean isScript;
        final JarState jarState;

        State(String version, Provisioner provisioner, boolean isScript) throws IOException {
            this.jarState = JarState.from(KtLintStep.MAVEN_COORDINATE + version, provisioner);
            this.isScript = isScript;
        }

        FormatterFunc createFormat() throws Exception {
            ClassLoader classLoader = this.jarState.getClassLoader();
            Class<?> standardRuleSetProviderClass = classLoader.loadClass("com.github.shyiko.ktlint.ruleset.standard.StandardRuleSetProvider");
            Object standardRuleSet = standardRuleSetProviderClass.getMethod("get", new Class[0]).invoke(standardRuleSetProviderClass.newInstance(), new Object[0]);
            List<Object> ruleSets = Collections.singletonList(standardRuleSet);
            Class<?> function2Interface = classLoader.loadClass("kotlin.jvm.functions.Function2");
            Class<?> lintErrorClass = classLoader.loadClass("com.github.shyiko.ktlint.core.LintError");
            Method detailGetter = lintErrorClass.getMethod("getDetail", new Class[0]);
            Object formatterCallback = Proxy.newProxyInstance(classLoader, new Class[]{function2Interface}, (proxy, method, args) -> {
                Object lintError = args[0];
                boolean corrected = (Boolean)args[1];
                if (!corrected) {
                    String detail = (String)detailGetter.invoke(lintError, new Object[0]);
                    throw new AssertionError((Object)detail);
                }
                return null;
            });
            Class<?> ktlintClass = classLoader.loadClass("com.github.shyiko.ktlint.core.KtLint");
            Object ktlint = ktlintClass.getDeclaredField("INSTANCE").get(null);
            String formatterMethodName = this.isScript ? "formatScript" : "format";
            Method formatterMethod = ktlintClass.getMethod(formatterMethodName, String.class, Iterable.class, function2Interface);
            return input -> {
                try {
                    String formatted = (String)formatterMethod.invoke(ktlint, input, ruleSets, formatterCallback);
                    return formatted;
                }
                catch (InvocationTargetException e) {
                    throw ThrowingEx.unwrapCause(e);
                }
            };
        }
    }
}

