/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.generic;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import java.io.Serializable;
import java.util.Objects;

public final class IndentStep {
    private IndentStep() {
    }

    public static FormatterStep create(Type type, int numSpacesPerTab) {
        Objects.requireNonNull(type, "type");
        return FormatterStep.create("indentWith" + (String)type.tabSpace("Tabs", "Spaces"), new State(type, numSpacesPerTab), State::toFormatter);
    }

    private static boolean isSpaceOrTab(char c) {
        return c == ' ' || c == '\t';
    }

    static class Runtime {
        final State state;
        final StringBuilder builder = new StringBuilder();

        Runtime(State state) {
            this.state = state;
        }

        String format(String raw) {
            this.builder.setLength(0);
            int lineStart = 0;
            while (true) {
                char c;
                int contentStart;
                int numSpaces = 0;
                block9: for (contentStart = lineStart; contentStart < raw.length() && IndentStep.isSpaceOrTab(c = raw.charAt(contentStart)); ++contentStart) {
                    switch (c) {
                        case ' ': {
                            ++numSpaces;
                            continue block9;
                        }
                        case '\t': {
                            numSpaces += this.state.numSpacesPerTab;
                            continue block9;
                        }
                        default: {
                            throw new IllegalArgumentException("Unexpected char " + c);
                        }
                    }
                }
                if (numSpaces > 0) {
                    switch (this.state.type) {
                        case SPACE: {
                            int i;
                            for (i = 0; i < numSpaces; ++i) {
                                this.builder.append(' ');
                            }
                            break;
                        }
                        case TAB: {
                            int i;
                            for (i = 0; i < numSpaces / this.state.numSpacesPerTab; ++i) {
                                this.builder.append('\t');
                            }
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unexpected enum " + (Object)((Object)this.state.type));
                        }
                    }
                }
                if ((lineStart = raw.indexOf(10, contentStart)) == -1) {
                    this.builder.append(raw.subSequence(contentStart, raw.length()));
                    return this.builder.toString();
                }
                this.builder.append(raw.subSequence(contentStart, ++lineStart));
            }
        }
    }

    private static class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final Type type;
        final int numSpacesPerTab;

        State(Type type, int numSpacesPerTab) {
            this.type = type;
            this.numSpacesPerTab = numSpacesPerTab;
        }

        FormatterFunc toFormatter() {
            return new Runtime(this)::format;
        }
    }

    public static enum Type {
        TAB,
        SPACE;


        private <T> T tabSpace(T tab, T space) {
            return this == TAB ? tab : space;
        }

        public FormatterStep create(int numSpacesPerTab) {
            return IndentStep.create(this, numSpacesPerTab);
        }
    }
}

