/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.MoreIterables;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class FileSignature
implements Serializable {
    private static final long serialVersionUID = 1L;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private final transient List<File> files;
    private final String[] filenames;
    private final long[] filesizes;
    private final long[] lastModified;

    @Deprecated
    public static FileSignature from(File ... files) throws IOException {
        return FileSignature.from(Arrays.asList(files));
    }

    @Deprecated
    public static FileSignature from(Iterable<File> files) throws IOException {
        return FileSignature.signAsSet(files);
    }

    public static FileSignature signAsList(File ... files) throws IOException {
        return FileSignature.signAsList(Arrays.asList(files));
    }

    public static FileSignature signAsList(Iterable<File> files) throws IOException {
        return new FileSignature(MoreIterables.toNullHostileList(files));
    }

    public static FileSignature signAsSet(File ... files) throws IOException {
        return FileSignature.signAsSet(Arrays.asList(files));
    }

    public static FileSignature signAsSet(Iterable<File> files) throws IOException {
        return new FileSignature(MoreIterables.toSortedSet(files));
    }

    private FileSignature(List<File> files) throws IOException {
        this.files = files;
        this.filenames = new String[this.files.size()];
        this.filesizes = new long[this.files.size()];
        this.lastModified = new long[this.files.size()];
        int i = 0;
        for (File file : this.files) {
            this.filenames[i] = file.getCanonicalPath();
            this.filesizes[i] = file.length();
            this.lastModified[i] = file.lastModified();
            ++i;
        }
    }

    public Collection<File> files() {
        return Collections.unmodifiableList(this.files);
    }

    public File getOnlyFile() {
        if (this.files.size() == 1) {
            return this.files.iterator().next();
        }
        throw new IllegalArgumentException("Expected one file, but was " + this.files.size());
    }
}

