/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.JarState;
import com.diffplug.spotless.LazyForwardingEquality;
import com.diffplug.spotless.ThrowingEx;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Serializable;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class SpotlessCache {
    final Map<SerializedKey, URLClassLoader> cache = new HashMap<SerializedKey, URLClassLoader>();
    private static final SpotlessCache instance = new SpotlessCache();

    @SuppressFBWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"})
    synchronized ClassLoader classloader(JarState state) {
        SerializedKey key = new SerializedKey(state);
        return this.cache.computeIfAbsent(key, k -> new URLClassLoader(state.jarUrls(), null));
    }

    static SpotlessCache instance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        ArrayList<URLClassLoader> toDelete;
        SpotlessCache spotlessCache = instance;
        synchronized (spotlessCache) {
            toDelete = new ArrayList<URLClassLoader>(SpotlessCache.instance.cache.values());
            SpotlessCache.instance.cache.clear();
        }
        for (URLClassLoader classLoader : toDelete) {
            try {
                classLoader.close();
            }
            catch (IOException e) {
                throw ThrowingEx.asRuntime(e);
            }
        }
    }

    static final class SerializedKey {
        final byte[] serialized;
        final int hashCode;

        SerializedKey(Serializable key) {
            Objects.requireNonNull(key);
            this.serialized = LazyForwardingEquality.toBytes(key);
            this.hashCode = Arrays.hashCode(this.serialized);
        }

        public final boolean equals(Object other) {
            return other instanceof SerializedKey && Arrays.equals(this.serialized, ((SerializedKey)other).serialized);
        }

        public final int hashCode() {
            return this.hashCode;
        }
    }
}

