/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra;

import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.extra.P2ModelWrapper;
import dev.equo.solstice.NestedJars;
import dev.equo.solstice.p2.CacheLocations;
import dev.equo.solstice.p2.P2ClientCache;
import dev.equo.solstice.p2.P2Model;
import dev.equo.solstice.p2.P2QueryCache;
import dev.equo.solstice.p2.P2QueryResult;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@FunctionalInterface
public interface P2Provisioner {
    public List<File> provisionP2Dependencies(P2ModelWrapper var1, Provisioner var2, @Nullable File var3) throws IOException;

    public static P2Provisioner createDefault() {
        return (modelWrapper, mavenProvisioner, cacheDirectory) -> {
            try {
                if (cacheDirectory != null) {
                    CacheLocations.override_p2data = cacheDirectory.toPath().resolve("dev/equo/p2-data").toFile();
                }
                P2Model model = modelWrapper.unwrap();
                P2QueryResult query = model.query(P2ClientCache.PREFER_OFFLINE, P2QueryCache.ALLOW);
                ArrayList<File> classpath = new ArrayList<File>();
                ArrayList<String> mavenDeps = new ArrayList<String>();
                mavenDeps.add("dev.equo.ide:solstice:1.8.1");
                mavenDeps.add("com.diffplug.durian:durian-swt.os:4.3.1");
                mavenDeps.addAll(query.getJarsOnMavenCentral());
                classpath.addAll(mavenProvisioner.provisionWithTransitives(false, mavenDeps));
                classpath.addAll(query.getJarsNotOnMavenCentral());
                for (Map.Entry nested : NestedJars.inFiles((Iterable)query.getJarsNotOnMavenCentral()).extractAllNestedJars()) {
                    classpath.add((File)nested.getValue());
                }
                return classpath;
            }
            catch (Exception e) {
                throw new IOException("Failed to provision P2 dependencies", e);
            }
        };
    }
}

