/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import javax.annotation.Nullable;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public class GitWorkarounds {
    private GitWorkarounds() {
    }

    @Nullable
    static File getDotGitDir(File projectDir) {
        return GitWorkarounds.fileRepositoryBuilderForProject(projectDir).getGitDir();
    }

    static FileRepositoryBuilder fileRepositoryBuilderForProject(File projectDir) {
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        builder.findGitDir(projectDir);
        File gitDir = builder.getGitDir();
        if (gitDir != null) {
            builder.setGitDir(GitWorkarounds.resolveRealGitDirIfWorktreeDir(gitDir));
        }
        return builder;
    }

    private static File resolveRealGitDirIfWorktreeDir(File dir) {
        File pointerFile = new File(dir, "gitdir");
        if (pointerFile.isFile()) {
            try {
                String content = new String(Files.readAllBytes(pointerFile.toPath()), StandardCharsets.UTF_8).trim();
                return new File(content);
            }
            catch (IOException e) {
                System.err.println("failed to parse git meta: " + e.getMessage());
                return dir;
            }
        }
        return dir;
    }
}

