/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.parser.regions;

import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.parser.regions.RegionToStringUtil;

public class EndTagOpenRegion
implements ITextRegion {
    private static final String fType = "XML_END_TAG_OPEN";
    private int fLength;
    private int fStart;
    private static final byte fTextLength = 2;

    public EndTagOpenRegion() {
    }

    public EndTagOpenRegion(int start, int textLength, int length) {
        this();
        this.fStart = start;
        if (2 != textLength) {
            throw new RuntimeException("invalid for this region type");
        }
        this.fLength = length;
    }

    public EndTagOpenRegion(int start, int length) {
        this();
        this.fStart = start;
        this.fLength = length;
    }

    @Override
    public void adjustLength(int i) {
        this.fLength += i;
    }

    @Override
    public void adjustStart(int i) {
        this.fStart += i;
    }

    @Override
    public void adjustTextLength(int i) {
        throw new RuntimeException("invalid for this region type");
    }

    @Override
    public void equatePositions(ITextRegion region) {
        this.fStart = region.getStart();
        this.fLength = region.getLength();
    }

    @Override
    public int getEnd() {
        return this.fStart + this.fLength;
    }

    @Override
    public int getLength() {
        return this.fLength;
    }

    @Override
    public int getStart() {
        return this.fStart;
    }

    @Override
    public int getTextEnd() {
        return this.fStart + 2;
    }

    @Override
    public int getTextLength() {
        return 2;
    }

    @Override
    public String getType() {
        return fType;
    }

    public String toString() {
        return RegionToStringUtil.toString(this);
    }

    @Override
    public StructuredDocumentEvent updateRegion(Object requester, IStructuredDocumentRegion parent, String changes, int requestStart, int lengthToReplace) {
        return null;
    }
}

