/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.parser;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.text.TextRegionListImpl;
import org.eclipse.wst.xml.core.internal.Logger;

public class ContextRegionContainer
implements ITextRegionContainer {
    protected int length;
    protected ITextRegionCollection parent;
    protected ITextRegionList regions = new TextRegionListImpl();
    protected int start;
    protected int textLength;
    protected String type;

    private IStructuredDocument _getParentDocument() {
        ITextRegionCollection parent = this.getParent();
        while (!(parent instanceof IStructuredDocumentRegion)) {
            parent = ((ITextRegionContainer)parent).getParent();
        }
        return ((IStructuredDocumentRegion)parent).getParentDocument();
    }

    public void adjust(int i) {
        this.start += i;
    }

    @Override
    public void adjustLength(int i) {
        this.length += i;
    }

    @Override
    public void adjustStart(int i) {
        this.start += i;
    }

    @Override
    public void adjustTextLength(int i) {
        this.textLength += i;
    }

    @Override
    public boolean containsOffset(int i) {
        return this.getStartOffset() <= i && i < this.getEndOffset();
    }

    @Override
    public boolean containsOffset(ITextRegion containedRegion, int offset) {
        return this.getStartOffset(containedRegion) <= offset && offset < this.getEndOffset(containedRegion);
    }

    @Override
    public void equatePositions(ITextRegion region) {
        this.start = region.getStart();
        this.length = region.getLength();
        this.textLength = region.getTextLength();
    }

    @Override
    public int getEnd() {
        return this.start + this.length;
    }

    @Override
    public int getEndOffset() {
        return this.getStartOffset() + this.getLength();
    }

    @Override
    public int getEndOffset(ITextRegion containedRegion) {
        return this.getStartOffset(containedRegion) + containedRegion.getLength();
    }

    @Override
    public ITextRegion getFirstRegion() {
        return this.getRegions().get(0);
    }

    @Override
    public String getFullText() {
        return this.getParent().getFullText(this);
    }

    @Override
    public String getFullText(ITextRegion aRegion) {
        return this.parent.getFullText().substring(this.start + aRegion.getStart(), this.start + aRegion.getEnd());
    }

    @Override
    public ITextRegion getLastRegion() {
        return this.getRegions().get(this.getRegions().size() - 1);
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getNumberOfRegions() {
        return this.getRegions().size();
    }

    @Override
    public ITextRegionCollection getParent() {
        return this.parent;
    }

    @Override
    public ITextRegion getRegionAtCharacterOffset(int offset) {
        ITextRegion result = null;
        if (this.regions != null) {
            int thisStartOffset = this.getStartOffset();
            if (offset < thisStartOffset) {
                return null;
            }
            int thisEndOffset = this.getStartOffset() + this.getLength();
            if (offset > thisEndOffset) {
                return null;
            }
            ITextRegionList regions = this.getRegions();
            int length = regions.size();
            int low = 0;
            int high = length;
            int mid = 0;
            while (low < high) {
                mid = low + (high - low >> 1);
                ITextRegion region = regions.get(mid);
                if (offset < region.getStart() + thisStartOffset) {
                    high = mid;
                    continue;
                }
                if (offset > region.getEnd() + thisStartOffset - 1) {
                    low = mid + 1;
                    continue;
                }
                return region;
            }
            return null;
        }
        return result;
    }

    @Override
    public ITextRegionList getRegions() {
        return this.regions;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getStartOffset() {
        return this.getParent().getStartOffset() + this.getStart();
    }

    @Override
    public int getStartOffset(ITextRegion containedRegion) {
        if (containedRegion == null) {
            return this.getStartOffset();
        }
        return this.getStartOffset() + containedRegion.getStart();
    }

    @Override
    public String getText() {
        String result = null;
        try {
            IStructuredDocument parentDocument = this._getParentDocument();
            result = parentDocument.get(this.start, this.length);
        }
        catch (BadLocationException e) {
            Logger.logException("program error: unreachable exception", e);
        }
        return result;
    }

    @Override
    public String getText(ITextRegion aRegion) {
        return this.parent.getText().substring(this.start + aRegion.getStart(), this.start + aRegion.getTextEnd());
    }

    @Override
    public int getTextEnd() {
        return this.start + this.textLength;
    }

    @Override
    public int getTextEndOffset() {
        ITextRegion region = this.regions.get(this.regions.size() - 1);
        return this.getStartOffset() + region.getTextEnd();
    }

    @Override
    public int getTextEndOffset(ITextRegion containedRegion) {
        int result = 0;
        if (this.regions != null) {
            int length = this.getRegions().size();
            int i = 0;
            while (i < length) {
                ITextRegion region = this.getRegions().get(i);
                if (region == containedRegion) {
                    result = this.getStartOffset(region) + region.getTextEnd();
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public int getTextLength() {
        return this.textLength;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setLength(int i) {
        this.length = i;
    }

    @Override
    public void setParent(ITextRegionCollection parentRegion) {
        this.parent = parentRegion;
    }

    @Override
    public void setRegions(ITextRegionList containedRegions) {
        this.regions = containedRegions;
    }

    public void setStart(int i) {
        this.start = i;
    }

    public void setTextLength(int i) {
        this.textLength = i;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String toString() {
        String className = this.getClass().getName();
        String shortClassName = className.substring(className.lastIndexOf(".") + 1);
        String result = "Container!!! " + shortClassName + "--> " + this.getType() + ": " + this.getStart() + "-" + this.getTextEnd() + (this.getTextEnd() != this.getEnd() ? "/" + this.getEnd() : "");
        return result;
    }

    @Override
    public StructuredDocumentEvent updateRegion(Object requester, IStructuredDocumentRegion parent, String changes, int requestStart, int lengthToReplace) {
        StructuredDocumentEvent result = null;
        return result;
    }
}

