/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.text.identifier.contentassist;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.wst.jsdt.internal.corext.template.java.CompilationUnitContextType;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.text.java.IdentifierProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.ScopedCodeAssistVisitor;

public class IdentifierEngine {
    private CompilationUnitContextType fContextType;
    private ArrayList<ICompletionProposal> fProposals = new ArrayList();
    private ScopedCodeAssistVisitor visitor;

    public IdentifierEngine(CompilationUnitContextType contextType) {
        Assert.isNotNull((Object)((Object)contextType));
        this.fContextType = contextType;
    }

    public void complete(IJavaScriptProject project, ITextViewer viewer, int completionPosition, IJavaScriptUnit compilationUnit) {
        IDocument document = viewer.getDocument();
        Point selection = viewer.getSelectedRange();
        Position position = new Position(completionPosition, selection.y);
        CompilationUnitContext context = this.fContextType.createContext(document, position, compilationUnit);
        int start = context.getStart();
        int end = context.getEnd();
        Region region = new Region(start, end - start);
        JavaScriptUnit ast = JavaScriptPlugin.getDefault().getASTProvider().getAST(compilationUnit, ASTProvider.WAIT_YES, (IProgressMonitor)new NullProgressMonitor());
        this.visitor = new ScopedCodeAssistVisitor(completionPosition);
        if (ast == null) {
            return;
        }
        ast.accept(this.visitor);
        if (context.getKey().contains(".")) {
            int dot = this.getMostRecentDot(context.getKey());
            region = new Region(start + dot + 1, end - start);
        }
        List<IdentifierProposal> identifierProposals = this.visitor.getIdentifiers(context.getKey());
        for (IdentifierProposal idenProp : identifierProposals) {
            idenProp.setRegion((IRegion)region);
        }
        this.fProposals.addAll(identifierProposals);
    }

    private int getMostRecentDot(String s) {
        int i = s.length() - 1;
        while (i > 0) {
            if (s.charAt(i) == '.') {
                return i;
            }
            --i;
        }
        return -1;
    }

    public void reset() {
        this.fProposals.clear();
    }

    public ICompletionProposal[] getResults() {
        return this.fProposals.toArray(new ICompletionProposal[this.fProposals.size()]);
    }

    public List<String> getMatchingIdentifiers(List<String> identifiers, String string) {
        return identifiers.stream().filter(k -> k.startsWith(string)).collect(Collectors.toList());
    }
}

