/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ChangeCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;
import org.eclipse.wst.jsdt.ui.wizards.NewTypeWizardPage;

public class NewCUCompletionUsingWizardProposal
extends ChangeCorrectionProposal {
    public static final int K_CLASS = 1;
    public static final int K_INTERFACE = 2;
    public static final int K_ENUM = 3;
    public static final int K_ANNOTATION = 4;
    private Name fNode;
    private IJavaScriptUnit fCompilationUnit;
    private int fTypeKind;
    private IJavaScriptElement fTypeContainer;
    private String fTypeNameWithParameters;
    private IType fCreatedType;
    private boolean fShowDialog;

    public NewCUCompletionUsingWizardProposal(IJavaScriptUnit cu, Name node, int typeKind, IJavaScriptElement typeContainer, int severity) {
        super("", null, severity, null);
        this.fCompilationUnit = cu;
        this.fNode = node;
        this.fTypeKind = typeKind;
        this.fTypeContainer = typeContainer;
        this.fTypeNameWithParameters = NewCUCompletionUsingWizardProposal.getTypeName(typeKind, node);
        this.fCreatedType = null;
        String containerName = ASTNodes.getQualifier(node);
        String typeName = this.fTypeNameWithParameters;
        boolean isInnerType = typeContainer instanceof IType;
        switch (typeKind) {
            case 1: {
                this.setImage(JavaPluginImages.get("org.eclipse.wst.jsdt.ui.class_obj.gif"));
                if (isInnerType) {
                    if (containerName.length() == 0) {
                        this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createinnerclass_description, typeName));
                        break;
                    }
                    this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createinnerclass_intype_description, new String[]{typeName, containerName}));
                    break;
                }
                if (containerName.length() == 0) {
                    this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createclass_description, typeName));
                    break;
                }
                this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createclass_inpackage_description, new String[]{typeName, containerName}));
                break;
            }
            case 2: {
                this.setImage(JavaPluginImages.get("org.eclipse.wst.jsdt.ui.int_obj.gif"));
                if (isInnerType) {
                    if (containerName.length() == 0) {
                        this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createinnerinterface_description, typeName));
                        break;
                    }
                    this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createinnerinterface_intype_description, new String[]{typeName, containerName}));
                    break;
                }
                if (containerName.length() == 0) {
                    this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createinterface_description, typeName));
                    break;
                }
                this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createinterface_inpackage_description, new String[]{typeName, containerName}));
                break;
            }
            case 3: {
                this.setImage(JavaPluginImages.get("org.eclipse.wst.jsdt.ui.enum_obj.gif"));
                if (isInnerType) {
                    if (containerName.length() == 0) {
                        this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createinnerenum_description, typeName));
                        break;
                    }
                    this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createinnerenum_intype_description, new String[]{typeName, containerName}));
                    break;
                }
                if (containerName.length() == 0) {
                    this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createenum_description, typeName));
                    break;
                }
                this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createenum_inpackage_description, new String[]{typeName, containerName}));
                break;
            }
            case 4: {
                this.setImage(JavaPluginImages.get("org.eclipse.wst.jsdt.ui.annotation_obj.gif"));
                if (isInnerType) {
                    if (containerName.length() == 0) {
                        this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createinnerannotation_description, typeName));
                        break;
                    }
                    this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createinnerannotation_intype_description, new String[]{typeName, containerName}));
                    break;
                }
                if (containerName.length() == 0) {
                    this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createannotation_description, typeName));
                    break;
                }
                this.setDisplayName(Messages.format(CorrectionMessages.NewCUCompletionUsingWizardProposal_createannotation_inpackage_description, new String[]{typeName, containerName}));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type kind");
            }
        }
        this.fShowDialog = true;
    }

    private static String getTypeName(int typeKind, Name node) {
        String name = ASTNodes.getSimpleNameIdentifier(node);
        return name;
    }

    @Override
    public void apply(IDocument document) {
    }

    private NewTypeWizardPage configureWizardPage(NewElementWizard wizard) {
        IWizardPage[] pages = wizard.getPages();
        Assert.isTrue((pages.length > 0 && pages[0] instanceof NewTypeWizardPage ? 1 : 0) != 0);
        NewTypeWizardPage page = (NewTypeWizardPage)pages[0];
        this.fillInWizardPageName(page);
        this.fillInWizardPageSuperTypes(page);
        return page;
    }

    private void fillInWizardPageName(NewTypeWizardPage page) {
        page.setTypeName(this.fTypeNameWithParameters, this.fTypeNameWithParameters.indexOf(60) != -1);
        boolean isInEnclosingType = this.fTypeContainer instanceof IType;
        if (isInEnclosingType) {
            page.setEnclosingType((IType)this.fTypeContainer, true);
        } else {
            page.setPackageFragment((IPackageFragment)this.fTypeContainer, true);
        }
        page.setEnclosingTypeSelection(isInEnclosingType, true);
    }

    private void fillInWizardPageSuperTypes(NewTypeWizardPage page) {
        ITypeBinding type = this.getPossibleSuperTypeBinding(this.fNode);
        if ((type = Bindings.normalizeTypeBinding(type)) != null) {
            if (type.isArray()) {
                type = type.getElementType();
            }
            if ((type.isTopLevel() || type.isMember()) && type.isClass() && this.fTypeKind == 1) {
                page.setSuperClass(type.getQualifiedName(), true);
            }
        }
    }

    private ITypeBinding getPossibleSuperTypeBinding(ASTNode node) {
        if (this.fTypeKind == 4) {
            return null;
        }
        AST ast = node.getAST();
        node = ASTNodes.getNormalizedNode(node);
        ASTNode parent = node.getParent();
        switch (parent.getNodeType()) {
            case 31: {
                if (node.getLocationInParent() != FunctionDeclaration.THROWN_EXCEPTIONS_PROPERTY) break;
                return ast.resolveWellKnownType("java.lang.Exception");
            }
            case 53: {
                return ast.resolveWellKnownType("java.lang.Exception");
            }
            case 44: {
                if (parent.getLocationInParent() != CatchClause.EXCEPTION_PROPERTY) break;
                return ast.resolveWellKnownType("java.lang.Exception");
            }
            case 23: 
            case 60: {
                return null;
            }
        }
        return ASTResolving.guessBindingForTypeReference(node);
    }

    @Override
    public String getAdditionalProposalInfo() {
        StringBuffer buf = new StringBuffer();
        switch (this.fTypeKind) {
            case 1: {
                buf.append(CorrectionMessages.NewCUCompletionUsingWizardProposal_createclass_info);
                break;
            }
            case 2: {
                buf.append(CorrectionMessages.NewCUCompletionUsingWizardProposal_createinterface_info);
                break;
            }
            case 3: {
                buf.append(CorrectionMessages.NewCUCompletionUsingWizardProposal_createenum_info);
                break;
            }
            case 4: {
                buf.append(CorrectionMessages.NewCUCompletionUsingWizardProposal_createannotation_info);
            }
        }
        buf.append("<br>");
        buf.append("<br>");
        if (this.fTypeContainer instanceof IType) {
            buf.append(CorrectionMessages.NewCUCompletionUsingWizardProposal_tooltip_enclosingtype);
        } else {
            buf.append(CorrectionMessages.NewCUCompletionUsingWizardProposal_tooltip_package);
        }
        buf.append(" <b>");
        buf.append(JavaScriptElementLabels.getElementLabel(this.fTypeContainer, 262144L));
        buf.append("</b><br>");
        buf.append("public ");
        switch (this.fTypeKind) {
            case 1: {
                buf.append("class <b>");
                break;
            }
            case 2: {
                buf.append("interface <b>");
                break;
            }
            case 3: {
                buf.append("enum <b>");
                break;
            }
            case 4: {
                buf.append("@interface <b>");
            }
        }
        this.nameToHTML(this.fTypeNameWithParameters, buf);
        ITypeBinding superclass = this.getPossibleSuperTypeBinding(this.fNode);
        if (superclass != null) {
            if (superclass.isClass()) {
                if (this.fTypeKind == 1) {
                    buf.append("</b> extends <b>");
                    this.nameToHTML(BindingLabelProvider.getBindingLabel(superclass, 0x20000AL), buf);
                }
            } else {
                if (this.fTypeKind == 2) {
                    buf.append("</b> extends <b>");
                } else {
                    buf.append("</b> implements <b>");
                }
                this.nameToHTML(BindingLabelProvider.getBindingLabel(superclass, 0x20000AL), buf);
            }
        }
        buf.append("</b> {<br>}<br>");
        return buf.toString();
    }

    private void nameToHTML(String name, StringBuffer buf) {
        int i = 0;
        while (i < name.length()) {
            char ch = name.charAt(i);
            if (ch == '>') {
                buf.append("&gt;");
            } else if (ch == '<') {
                buf.append("&lt;");
            } else {
                buf.append(ch);
            }
            ++i;
        }
    }

    public boolean isShowDialog() {
        return this.fShowDialog;
    }

    public void setShowDialog(boolean showDialog) {
        this.fShowDialog = showDialog;
    }

    public IType getCreatedType() {
        return this.fCreatedType;
    }

    public int getTypeKind() {
        return this.fTypeKind;
    }
}

