/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.reorg;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptModel;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IReorgDestinationValidator;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.ui.StandardJavaScriptElementContentProvider;

public final class DestinationContentProvider
extends StandardJavaScriptElementContentProvider {
    private IReorgDestinationValidator fValidator;

    public DestinationContentProvider(IReorgDestinationValidator validator) {
        super(true);
        this.fValidator = validator;
    }

    @Override
    public boolean hasChildren(Object element) {
        IResource resource;
        if (element instanceof IJavaScriptElement) {
            IJavaScriptElement javaElement = (IJavaScriptElement)element;
            if (!this.fValidator.canChildrenBeDestinations(javaElement)) {
                return false;
            }
            if (javaElement.getElementType() == 3 && ((IPackageFragmentRoot)javaElement).isArchive()) {
                return false;
            }
        } else if (element instanceof IResource && !this.fValidator.canChildrenBeDestinations(resource = (IResource)element)) {
            return false;
        }
        return super.hasChildren(element);
    }

    @Override
    public Object[] getChildren(Object element) {
        try {
            if (element instanceof IJavaScriptModel) {
                return DestinationContentProvider.concatenate(this.getJavaProjects((IJavaScriptModel)element), DestinationContentProvider.getOpenNonJavaProjects((IJavaScriptModel)element));
            }
            Object[] children = this.doGetChildren(element);
            ArrayList<IJavaScriptElement> result = new ArrayList<IJavaScriptElement>(children.length);
            int i = 0;
            while (i < children.length) {
                IResource resource;
                if (children[i] instanceof IJavaScriptElement) {
                    IJavaScriptElement javaElement = (IJavaScriptElement)children[i];
                    if (this.fValidator.canElementBeDestination(javaElement) || this.fValidator.canChildrenBeDestinations(javaElement)) {
                        result.add(javaElement);
                    }
                } else if (children[i] instanceof IResource && (this.fValidator.canElementBeDestination(resource = (IResource)children[i]) || this.fValidator.canChildrenBeDestinations(resource))) {
                    result.add((IJavaScriptElement)resource);
                }
                ++i;
            }
            return result.toArray();
        }
        catch (JavaScriptModelException e) {
            JavaScriptPlugin.log((Throwable)((Object)e));
            return new Object[0];
        }
    }

    private Object[] doGetChildren(Object parentElement) {
        if (parentElement instanceof IContainer) {
            IContainer container = (IContainer)parentElement;
            return this.getResources(container);
        }
        return super.getChildren(parentElement);
    }

    private Object[] getResources(IContainer container) {
        try {
            Object[] members = container.members();
            IJavaScriptProject javaProject = JavaScriptCore.create(container.getProject());
            if (javaProject == null || !javaProject.exists()) {
                return members;
            }
            boolean isFolderOnClasspath = javaProject.isOnIncludepath((IResource)container);
            ArrayList<Object> nonJavaResources = new ArrayList<Object>();
            int i = 0;
            while (i < members.length) {
                Object member = members[i];
                if (isFolderOnClasspath) {
                    if (javaProject.findPackageFragmentRoot(member.getFullPath()) == null) {
                        nonJavaResources.add(member);
                    }
                } else if (!javaProject.isOnIncludepath((IResource)member)) {
                    nonJavaResources.add(member);
                }
                ++i;
            }
            return nonJavaResources.toArray();
        }
        catch (CoreException coreException) {
            return NO_CHILDREN;
        }
    }

    private static Object[] getOpenNonJavaProjects(IJavaScriptModel model) throws JavaScriptModelException {
        Object[] nonJavaProjects = model.getNonJavaScriptResources();
        ArrayList<IProject> result = new ArrayList<IProject>(nonJavaProjects.length);
        int i = 0;
        while (i < nonJavaProjects.length) {
            IProject project = (IProject)nonJavaProjects[i];
            if (project.isOpen()) {
                result.add(project);
            }
            ++i;
        }
        return result.toArray();
    }
}

