/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.callhierarchy;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.CallHierarchy;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.CallLocation;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.JavaScriptUI;

public class CallHierarchyUI {
    private static final int DEFAULT_MAX_CALL_DEPTH = 10;
    private static final String PREF_MAX_CALL_DEPTH = "PREF_MAX_CALL_DEPTH";
    private static CallHierarchyUI fgInstance;

    private CallHierarchyUI() {
    }

    public static CallHierarchyUI getDefault() {
        if (fgInstance == null) {
            fgInstance = new CallHierarchyUI();
        }
        return fgInstance;
    }

    public int getMaxCallDepth() {
        IPreferenceStore settings = JavaScriptPlugin.getDefault().getPreferenceStore();
        int maxCallDepth = settings.getInt(PREF_MAX_CALL_DEPTH);
        if (maxCallDepth < 1 || maxCallDepth > 99) {
            maxCallDepth = 10;
        }
        return maxCallDepth;
    }

    public void setMaxCallDepth(int maxCallDepth) {
        IPreferenceStore settings = JavaScriptPlugin.getDefault().getPreferenceStore();
        settings.setValue(PREF_MAX_CALL_DEPTH, maxCallDepth);
    }

    public static void jumpToMember(IJavaScriptElement element) {
        if (element != null) {
            try {
                JavaScriptUI.openInEditor(element, true, true);
            }
            catch (JavaScriptModelException e) {
                JavaScriptPlugin.log((Throwable)((Object)e));
            }
            catch (PartInitException e) {
                JavaScriptPlugin.log(e);
            }
        }
    }

    public static void jumpToLocation(CallLocation callLocation) {
        try {
            IEditorPart methodEditor = JavaScriptUI.openInEditor(callLocation.getMember(), false, false);
            if (methodEditor instanceof ITextEditor) {
                ITextEditor editor = (ITextEditor)methodEditor;
                editor.selectAndReveal(callLocation.getStart(), callLocation.getEnd() - callLocation.getStart());
            }
        }
        catch (JavaScriptModelException e) {
            JavaScriptPlugin.log((Throwable)((Object)e));
        }
        catch (PartInitException e) {
            JavaScriptPlugin.log(e);
        }
    }

    public static boolean openInEditor(Object element, Shell shell, String title) {
        int selectionLength;
        int selectionStart;
        IMember enclosingMember;
        CallLocation callLocation;
        block9: {
            block10: {
                ISourceRange selectionRange;
                block11: {
                    callLocation = CallHierarchy.getCallLocation(element);
                    if (callLocation != null) {
                        enclosingMember = callLocation.getMember();
                        selectionStart = callLocation.getStart();
                        selectionLength = callLocation.getEnd() - selectionStart;
                        break block9;
                    }
                    if (!(element instanceof MethodWrapper)) break block10;
                    enclosingMember = ((MethodWrapper)((Object)element)).getMember();
                    if (enclosingMember.isVirtual()) {
                        selectionStart = 0;
                        selectionLength = 0;
                        break block9;
                    }
                    selectionRange = enclosingMember.getNameRange();
                    if (selectionRange == null) {
                        selectionRange = enclosingMember.getSourceRange();
                    }
                    if (selectionRange != null) break block11;
                    return true;
                }
                selectionStart = selectionRange.getOffset();
                selectionLength = selectionRange.getLength();
                break block9;
            }
            return true;
        }
        try {
            boolean activateOnOpen = OpenStrategy.activateOnOpen();
            IEditorPart methodEditor = JavaScriptUI.openInEditor(enclosingMember, activateOnOpen, false);
            if (methodEditor instanceof ITextEditor) {
                ITextEditor editor = (ITextEditor)methodEditor;
                editor.selectAndReveal(selectionStart, selectionLength);
            }
            return true;
        }
        catch (JavaScriptModelException e) {
            JavaScriptPlugin.log((IStatus)new Status(4, JavaScriptPlugin.getPluginId(), 10001, CallHierarchyMessages.CallHierarchyUI_open_in_editor_error_message, (Throwable)((Object)e)));
            ErrorDialog.openError((Shell)shell, (String)title, (String)CallHierarchyMessages.CallHierarchyUI_open_in_editor_error_message, (IStatus)e.getStatus());
            return false;
        }
        catch (PartInitException x) {
            String name = callLocation != null ? callLocation.getCalledMember().getElementName() : (element instanceof MethodWrapper ? ((MethodWrapper)((Object)element)).getName() : "");
            MessageDialog.openError((Shell)shell, (String)title, (String)Messages.format(CallHierarchyMessages.CallHierarchyUI_open_in_editor_error_messageArgs, new String[]{name, x.getMessage()}));
            return false;
        }
    }

    public static IEditorPart isOpenInEditor(Object elem) {
        IMember javaElement = null;
        if (elem instanceof MethodWrapper) {
            javaElement = ((MethodWrapper)((Object)elem)).getMember();
        } else if (elem instanceof CallLocation) {
            javaElement = ((CallLocation)elem).getCalledMember();
        }
        if (javaElement != null) {
            return EditorUtility.isOpenInEditor(javaElement);
        }
        return null;
    }

    public static IJavaScriptElement[] getCandidates(Object input) {
        if (!(input instanceof IJavaScriptElement)) {
            return null;
        }
        IJavaScriptElement elem = (IJavaScriptElement)input;
        if (elem.getElementType() == 9) {
            return new IJavaScriptElement[]{elem};
        }
        return null;
    }

    public static CallHierarchyViewPart open(IJavaScriptElement[] candidates, IWorkbenchWindow window) {
        Assert.isTrue((candidates != null && candidates.length != 0 ? 1 : 0) != 0);
        IJavaScriptElement input = null;
        if (candidates.length > 1) {
            String title = CallHierarchyMessages.CallHierarchyUI_selectionDialog_title;
            String message = CallHierarchyMessages.CallHierarchyUI_selectionDialog_message;
            input = SelectionConverter.selectJavaElement(candidates, window.getShell(), title, message);
        } else {
            input = candidates[0];
        }
        if (input == null) {
            return null;
        }
        return CallHierarchyUI.openInViewPart(window, input);
    }

    private static CallHierarchyViewPart openInViewPart(IWorkbenchWindow window, IJavaScriptElement input) {
        IWorkbenchPage page = window.getActivePage();
        try {
            CallHierarchyViewPart result = (CallHierarchyViewPart)page.showView("org.eclipse.wst.jsdt.callhierarchy.view");
            result.setMethod((IFunction)input);
            return result;
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, window.getShell(), CallHierarchyMessages.CallHierarchyUI_error_open_view, e.getMessage());
            return null;
        }
    }

    static ISelection convertSelection(ISelection selection) {
        if (selection.isEmpty()) {
            return selection;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            ArrayList<IMember> javaElements = new ArrayList<IMember>();
            for (Object element : structuredSelection) {
                IMember member;
                if (element instanceof MethodWrapper) {
                    member = ((MethodWrapper)((Object)element)).getMember();
                    if (member == null) continue;
                    javaElements.add(member);
                    continue;
                }
                if (element instanceof IMember) {
                    javaElements.add((IMember)element);
                    continue;
                }
                if (!(element instanceof CallLocation)) continue;
                member = ((CallLocation)element).getMember();
                javaElements.add(member);
            }
            return new StructuredSelection(javaElements);
        }
        return StructuredSelection.EMPTY;
    }
}

