/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.template.java;

import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;

public final class SignatureUtil {
    private static final String OBJECT_SIGNATURE = "Ljava.lang.Object;";
    public static final String BOOLEAN_SIGNATURE = "LBoolean;";

    private SignatureUtil() {
    }

    public static boolean isJavaLangObject(String signature) {
        return OBJECT_SIGNATURE.equals(signature);
    }

    public static String stripSignatureToFQN(String signature) throws IllegalArgumentException {
        signature = Signature.getElementType(signature);
        return Signature.toString(signature);
    }

    public static String qualifySignature(String signature, IType context) {
        String elementType;
        if (context == null) {
            return signature;
        }
        String qualifier = Signature.getSignatureQualifier(signature);
        if (qualifier.length() > 0) {
            return signature;
        }
        String erasure = elementType = Signature.getElementType(signature);
        String simpleName = Signature.getSignatureSimpleName(erasure);
        String genericSimpleName = Signature.getSignatureSimpleName(elementType);
        int dim = Signature.getArrayCount(signature);
        try {
            String[][] strings = context.resolveType(simpleName);
            if (strings != null && strings.length > 0) {
                qualifier = strings[0][0];
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {}
        if (qualifier.length() == 0) {
            return signature;
        }
        String qualifiedType = Signature.toQualifiedName(new String[]{qualifier, genericSimpleName});
        String qualifiedSignature = Signature.createTypeSignature(qualifiedType, true);
        String newSignature = Signature.createArraySignature(qualifiedSignature, dim);
        return newSignature;
    }

    public static char[] unboundedSignature(char[] signature) {
        if (signature == null || signature.length < 2) {
            return signature;
        }
        StringBuffer res = new StringBuffer("(");
        char[][] parameters = Signature.getParameterTypes(signature);
        int i = 0;
        while (i < parameters.length) {
            char[] param = parameters[i];
            res.append(param);
            ++i;
        }
        res.append(')');
        res.append(Signature.getReturnType(signature));
        return res.toString().toCharArray();
    }

    private static int typeEnd(char[] signature, int pos) {
        boolean depth = false;
        while (pos < signature.length) {
            switch (signature[pos]) {
                case ';': {
                    if (depth) break;
                    return pos + 1;
                }
            }
            ++pos;
        }
        return pos + 1;
    }
}

