/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.wst.jsdt.core.formatter.IndentManipulation;
import org.eclipse.wst.jsdt.internal.corext.dom.TokenScanner;

public class SelectionAwareSourceRangeComputer
extends TargetSourceRangeComputer {
    private ASTNode[] fSelectedNodes;
    private IDocument fDocument;
    private int fSelectionStart;
    private int fSelectionLength;
    private Map fRanges;

    public SelectionAwareSourceRangeComputer(ASTNode[] selectedNodes, IDocument document, int selectionStart, int selectionLength) throws BadLocationException, CoreException {
        this.fSelectedNodes = selectedNodes;
        this.fDocument = document;
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
    }

    @Override
    public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode node) {
        try {
            TargetSourceRangeComputer.SourceRange result;
            if (this.fRanges == null) {
                this.initializeRanges();
            }
            if ((result = (TargetSourceRangeComputer.SourceRange)this.fRanges.get(node)) != null) {
                return result;
            }
            return super.computeSourceRange(node);
        }
        catch (BadLocationException badLocationException) {
            this.fRanges = new HashMap();
        }
        catch (CoreException coreException) {
            this.fRanges = new HashMap();
        }
        return super.computeSourceRange(node);
    }

    /*
     * Unable to fully structure code
     */
    private void initializeRanges() throws BadLocationException, CoreException {
        block5: {
            this.fRanges = new HashMap<K, V>();
            if (this.fSelectedNodes.length == 0) {
                return;
            }
            this.fRanges.put(this.fSelectedNodes[0], super.computeSourceRange(this.fSelectedNodes[0]));
            last = this.fSelectedNodes.length - 1;
            this.fRanges.put(this.fSelectedNodes[last], super.computeSourceRange(this.fSelectedNodes[last]));
            scanner = ToolFactory.createScanner(true, false, false, false);
            documentPortionToScan = this.fDocument.get(this.fSelectionStart, this.fSelectionLength);
            scanner.setSource(documentPortionToScan.toCharArray());
            tokenizer = new TokenScanner(scanner);
            pos = tokenizer.getNextStartOffset(0, false);
            currentNode = this.fSelectedNodes[0];
            newStart = Math.min(this.fSelectionStart + pos, currentNode.getStartPosition());
            range = (TargetSourceRangeComputer.SourceRange)this.fRanges.get(currentNode);
            this.fRanges.put(currentNode, new TargetSourceRangeComputer.SourceRange(newStart, range.getLength() + range.getStartPosition() - newStart));
            currentNode = this.fSelectedNodes[last];
            scannerStart = currentNode.getStartPosition() + currentNode.getLength() - this.fSelectionStart;
            tokenizer.setOffset(scannerStart);
            pos = scannerStart;
            token = -1;
            try {
                while (true) {
                    token = tokenizer.readNext(false);
                    pos = tokenizer.getCurrentEndOffset();
                }
            }
            catch (CoreException v0) {
                if (token != 1001) break block5;
                index = pos - 1;
                ** while (index >= 0 && IndentManipulation.isLineDelimiterChar((char)documentPortionToScan.charAt((int)index)))
            }
lbl-1000:
            // 1 sources

            {
                --pos;
                --index;
                continue;
            }
        }
        newEnd = Math.max(this.fSelectionStart + pos, currentNode.getStartPosition() + currentNode.getLength());
        range = (TargetSourceRangeComputer.SourceRange)this.fRanges.get(currentNode);
        this.fRanges.put(currentNode, new TargetSourceRangeComputer.SourceRange(range.getStartPosition(), newEnd - range.getStartPosition()));
    }
}

