/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.binary;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;

public class StubCreator {
    protected StringBuffer fBuffer;
    protected final boolean fStubInvisible;

    public StubCreator(boolean stubInvisible) {
        this.fStubInvisible = stubInvisible;
    }

    protected void appendEnumConstants(IType type) throws JavaScriptModelException {
        IField[] fields = type.getFields();
        ArrayList list = new ArrayList(fields.length);
        int index = 0;
        while (index < list.size()) {
            if (index > 0) {
                this.fBuffer.append(",");
            }
            this.fBuffer.append(((IField)list.get(index)).getElementName());
            ++index;
        }
        this.fBuffer.append(";");
    }

    protected void appendExpression(String signature) {
        this.fBuffer.append("(");
        this.fBuffer.append(Signature.toString(signature));
        this.fBuffer.append(")");
        this.fBuffer.append("null");
    }

    protected void appendFieldDeclaration(IField field) throws JavaScriptModelException {
        this.appendFlags(field);
        this.fBuffer.append(" ");
        String signature = field.getTypeSignature();
        this.fBuffer.append(Signature.toString(signature));
        this.fBuffer.append(" ");
        this.fBuffer.append(field.getElementName());
        this.fBuffer.append(";");
    }

    protected void appendFlags(IMember member) throws JavaScriptModelException {
        int flags = member.getFlags();
        int kind = member.getElementType();
        if (kind == 7) {
            flags &= 0xFFFFFFDF;
            IType type = (IType)member;
            if (!type.isMember()) {
                flags &= 0xFFFFFFFD;
            }
        }
        if (kind == 9) {
            flags &= 0xFFFFFF7F;
        }
        if (flags != 0) {
            this.fBuffer.append(Flags.toString(flags));
        }
    }

    protected void appendMembers(IType type, IProgressMonitor monitor) throws JavaScriptModelException {
        try {
            monitor.beginTask(RefactoringCoreMessages.StubCreationOperation_creating_type_stubs, 1);
            IJavaScriptElement[] children = type.getChildren();
            int index = 0;
            while (index < children.length) {
                boolean stub;
                IMember child = (IMember)children[index];
                int flags = child.getFlags();
                boolean isPrivate = Flags.isPrivate(flags);
                boolean isDefault = !Flags.isPublic(flags) && !isPrivate;
                boolean bl = stub = this.fStubInvisible || !isPrivate && !isDefault;
                if (child instanceof IType) {
                    if (stub) {
                        this.appendTypeDeclaration((IType)child, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                } else if (child instanceof IField) {
                    if (stub) {
                        this.appendFieldDeclaration((IField)child);
                    }
                } else if (child instanceof IFunction) {
                    boolean skip;
                    IFunction method = (IFunction)child;
                    String name = method.getElementName();
                    boolean bl2 = skip = !stub || name.equals("<clinit>");
                    if (method.isConstructor()) {
                        skip = false;
                    }
                    if (!skip) {
                        this.appendMethodDeclaration(method);
                    }
                }
                this.fBuffer.append("\n");
                ++index;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void appendMethodBody(IFunction method) throws JavaScriptModelException {
        if (method.isConstructor()) {
            IType superclass;
            IType declaringType = method.getDeclaringType();
            String superSignature = declaringType.getSuperclassTypeSignature();
            if (superSignature != null && (superclass = declaringType.getJavaScriptProject().findType(Signature.getSignatureQualifier(superSignature), Signature.getSignatureSimpleName(superSignature))) != null) {
                String[] superParameters;
                int paramLength;
                IFunction[] superMethods = superclass.getFunctions();
                IFunction superConstructor = null;
                int length = superMethods.length;
                int index = 0;
                while (index < length) {
                    IFunction superMethod = superMethods[index];
                    if (superMethod.isConstructor() && !Flags.isPrivate(superMethod.getFlags())) {
                        superConstructor = superMethod;
                        break;
                    }
                    ++index;
                }
                if (superConstructor != null && (paramLength = (superParameters = superConstructor.getParameterTypes()).length) != 0) {
                    this.fBuffer.append("super(");
                    int index2 = 0;
                    while (index2 < paramLength) {
                        if (index2 > 0) {
                            this.fBuffer.append(",");
                        }
                        this.appendExpression(superParameters[index2]);
                        ++index2;
                    }
                    this.fBuffer.append(");");
                }
            }
        } else {
            String returnType = method.getReturnType();
            if (!"V".equals(returnType)) {
                this.fBuffer.append("return ");
                this.appendExpression(returnType);
                this.fBuffer.append(";");
            }
        }
    }

    protected void appendMethodDeclaration(IFunction method) throws JavaScriptModelException {
        this.appendFlags(method);
        this.fBuffer.append(" ");
        String returnType = method.getReturnType();
        if (!method.isConstructor()) {
            this.fBuffer.append(Signature.toString(returnType));
            this.fBuffer.append(" ");
        }
        this.fBuffer.append(method.getElementName());
        this.fBuffer.append("(");
        String[] parameterTypes = method.getParameterTypes();
        int flags = method.getFlags();
        boolean varargs = Flags.isVarargs(flags);
        int parameterLength = parameterTypes.length;
        int index = 0;
        while (index < parameterLength) {
            if (index > 0) {
                this.fBuffer.append(",");
            }
            this.fBuffer.append(Signature.toString(parameterTypes[index]));
            if (varargs && index == parameterLength - 1) {
                int length = this.fBuffer.length();
                if (length >= 2 && this.fBuffer.indexOf("[]", length - 2) >= 0) {
                    this.fBuffer.setLength(length - 2);
                }
                this.fBuffer.append("...");
            }
            this.fBuffer.append(" ");
            this.appendMethodParameterName(method, index);
            ++index;
        }
        this.fBuffer.append(")");
        if (Flags.isAbstract(flags)) {
            this.fBuffer.append(";");
        } else {
            this.fBuffer.append("{\n");
            this.appendMethodBody(method);
            this.fBuffer.append("}");
        }
    }

    protected void appendMethodParameterName(IFunction method, int index) {
        this.fBuffer.append("a");
        this.fBuffer.append(index);
    }

    protected void appendTopLevelType(IType type, IProgressMonitor subProgressMonitor) throws JavaScriptModelException {
        String packageName = type.getPackageFragment().getElementName();
        if (packageName.length() > 0) {
            this.fBuffer.append("package ");
            this.fBuffer.append(packageName);
            this.fBuffer.append(";\n");
        }
        this.appendTypeDeclaration(type, subProgressMonitor);
    }

    protected void appendTypeDeclaration(IType type, IProgressMonitor monitor) throws JavaScriptModelException {
        try {
            monitor.beginTask(RefactoringCoreMessages.StubCreationOperation_creating_type_stubs, 1);
            if (type.isClass()) {
                this.appendFlags(type);
                this.fBuffer.append(" class ");
                this.fBuffer.append(type.getElementName());
                String signature = type.getSuperclassTypeSignature();
                if (signature != null) {
                    this.fBuffer.append(" extends ");
                    this.fBuffer.append(Signature.toString(signature));
                }
                this.fBuffer.append("{\n");
                this.appendMembers(type, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.fBuffer.append("}");
            }
        }
        finally {
            monitor.done();
        }
    }

    public String createStub(IType topLevelType, IProgressMonitor monitor) throws JavaScriptModelException {
        Assert.isTrue((boolean)Checks.isTopLevel(topLevelType));
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.fBuffer = new StringBuffer(2046);
        this.appendTopLevelType(topLevelType, monitor);
        String result = this.fBuffer.toString();
        this.fBuffer = null;
        return result;
    }
}

