/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.IPackageBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.SuperFieldAccess;
import org.eclipse.wst.jsdt.internal.corext.dom.TypeBindingVisitor;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;

public class Bindings {
    public static final String ARRAY_LENGTH_FIELD_BINDING_STRING = "(array type):length";

    private Bindings() {
    }

    public static boolean equals(IBinding b1, IBinding b2) {
        return b1.isEqualTo(b2);
    }

    public static boolean equals(IBinding[] b1, IBinding[] b2) {
        Assert.isNotNull((Object)b1);
        if (b1 == b2) {
            return true;
        }
        if (b2 == null) {
            return false;
        }
        if (b1.length != b2.length) {
            return false;
        }
        int i = 0;
        while (i < b1.length) {
            if (!Bindings.equals(b1[i], b2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int hashCode(IBinding binding) {
        Assert.isNotNull((Object)binding);
        String key = binding.getKey();
        if (key == null) {
            return binding.hashCode();
        }
        return key.hashCode();
    }

    public static String asString(IBinding binding) {
        if (binding instanceof IFunctionBinding) {
            return Bindings.asString((IFunctionBinding)binding);
        }
        if (binding instanceof ITypeBinding) {
            return ((ITypeBinding)binding).getQualifiedName();
        }
        if (binding instanceof IVariableBinding) {
            return Bindings.asString((IVariableBinding)binding);
        }
        return binding.toString();
    }

    private static String asString(IVariableBinding variableBinding) {
        if (!variableBinding.isField()) {
            return variableBinding.toString();
        }
        if (variableBinding.getDeclaringClass() == null) {
            Assert.isTrue((boolean)variableBinding.getName().equals("length"));
            return ARRAY_LENGTH_FIELD_BINDING_STRING;
        }
        StringBuffer result = new StringBuffer();
        result.append(variableBinding.getDeclaringClass().getName());
        result.append(':');
        result.append(variableBinding.getName());
        return result.toString();
    }

    private static String asString(IFunctionBinding method) {
        StringBuffer result = new StringBuffer();
        result.append(method.getDeclaringClass().getName());
        result.append(':');
        result.append(method.getName());
        result.append('(');
        ITypeBinding[] parameters = method.getParameterTypes();
        int lastComma = parameters.length - 1;
        int i = 0;
        while (i < parameters.length) {
            ITypeBinding parameter = parameters[i];
            result.append(parameter.getName());
            if (i < lastComma) {
                result.append(", ");
            }
            ++i;
        }
        result.append(')');
        return result.toString();
    }

    public static String getTypeQualifiedName(ITypeBinding type) {
        ArrayList result = new ArrayList(5);
        Bindings.createName(type, false, result);
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < result.size()) {
            if (i > 0) {
                buffer.append('.');
            }
            buffer.append((String)result.get(i));
            ++i;
        }
        return buffer.toString();
    }

    public static String getFullyQualifiedName(ITypeBinding type) {
        String name = type.getQualifiedName();
        int index = name.indexOf(60);
        if (index > 0) {
            name = name.substring(0, index);
        }
        return name;
    }

    public static String getImportName(IBinding binding) {
        ITypeBinding declaring = null;
        switch (binding.getKind()) {
            case 2: {
                return Bindings.getRawQualifiedName((ITypeBinding)binding);
            }
            case 1: {
                return String.valueOf(binding.getName()) + ".*";
            }
            case 4: {
                declaring = ((IFunctionBinding)binding).getDeclaringClass();
                break;
            }
            case 3: {
                declaring = ((IVariableBinding)binding).getDeclaringClass();
                if (declaring != null) break;
                return binding.getName();
            }
            default: {
                return binding.getName();
            }
        }
        return JavaModelUtil.concatenateName(Bindings.getRawQualifiedName(declaring), binding.getName());
    }

    private static void createName(ITypeBinding type, boolean includePackage, List list) {
        ITypeBinding baseType = type;
        if (type.isArray()) {
            baseType = type.getElementType();
        }
        if (!baseType.isPrimitive() && !baseType.isNullType()) {
            ITypeBinding declaringType = baseType.getDeclaringClass();
            if (declaringType != null) {
                Bindings.createName(declaringType, includePackage, list);
            } else if (includePackage && !baseType.getPackage().isUnnamed()) {
                String[] components = baseType.getPackage().getNameComponents();
                int i = 0;
                while (i < components.length) {
                    list.add(components[i]);
                    ++i;
                }
            }
        }
        if (!baseType.isAnonymous()) {
            list.add(type.getName());
        } else {
            list.add("$local$");
        }
    }

    public static String[] getNameComponents(ITypeBinding type) {
        ArrayList result = new ArrayList(5);
        Bindings.createName(type, false, result);
        return result.toArray(new String[result.size()]);
    }

    public static String[] getAllNameComponents(ITypeBinding type) {
        ArrayList result = new ArrayList(5);
        Bindings.createName(type, true, result);
        return result.toArray(new String[result.size()]);
    }

    public static ITypeBinding getTopLevelType(ITypeBinding type) {
        ITypeBinding parent = type.getDeclaringClass();
        while (parent != null) {
            type = parent;
            parent = type.getDeclaringClass();
        }
        return type;
    }

    public static boolean isRuntimeException(ITypeBinding thrownException) {
        if (thrownException == null || thrownException.isPrimitive() || thrownException.isArray()) {
            return false;
        }
        return Bindings.findTypeInHierarchy(thrownException, "java.lang.RuntimeException") != null;
    }

    public static IVariableBinding findFieldInType(ITypeBinding type, String fieldName) {
        if (type.isPrimitive()) {
            return null;
        }
        IVariableBinding[] fields = type.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            IVariableBinding field = fields[i];
            if (field.getName().equals(fieldName)) {
                return field;
            }
            ++i;
        }
        return null;
    }

    public static IVariableBinding findFieldInHierarchy(ITypeBinding type, String fieldName) {
        IVariableBinding field = Bindings.findFieldInType(type, fieldName);
        if (field != null) {
            return field;
        }
        ITypeBinding superClass = type.getSuperclass();
        if (superClass != null && (field = Bindings.findFieldInHierarchy(superClass, fieldName)) != null) {
            return field;
        }
        return null;
    }

    public static IFunctionBinding findMethodInType(ITypeBinding type, String methodName, ITypeBinding[] parameters) {
        if (type.isPrimitive()) {
            return null;
        }
        IFunctionBinding[] methods = type.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            if (parameters == null ? methodName.equals(methods[i].getName()) : Bindings.isEqualMethod(methods[i], methodName, parameters)) {
                return methods[i];
            }
            ++i;
        }
        return null;
    }

    public static IFunctionBinding findMethodInHierarchy(ITypeBinding type, String methodName, ITypeBinding[] parameters) {
        if (type == null) {
            return null;
        }
        IFunctionBinding method = Bindings.findMethodInType(type, methodName, parameters);
        if (method != null) {
            return method;
        }
        ITypeBinding superClass = type.getSuperclass();
        if (superClass != null && (method = Bindings.findMethodInHierarchy(superClass, methodName, parameters)) != null) {
            return method;
        }
        return null;
    }

    public static IFunctionBinding findMethodInType(ITypeBinding type, String methodName, String[] parameters) {
        if (type.isPrimitive()) {
            return null;
        }
        IFunctionBinding[] methods = type.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            if (parameters == null ? methodName.equals(methods[i].getName()) : Bindings.isEqualMethod(methods[i], methodName, parameters)) {
                return methods[i];
            }
            ++i;
        }
        return null;
    }

    public static IFunctionBinding findMethodInHierarchy(ITypeBinding type, String methodName, String[] parameters) {
        IFunctionBinding method = Bindings.findMethodInType(type, methodName, parameters);
        if (method != null) {
            return method;
        }
        ITypeBinding superClass = type.getSuperclass();
        if (superClass != null && (method = Bindings.findMethodInHierarchy(superClass, methodName, parameters)) != null) {
            return method;
        }
        return null;
    }

    public static IFunctionBinding findOverriddenMethodInType(ITypeBinding type, IFunctionBinding method) {
        IFunctionBinding[] methods = type.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            if (Bindings.isSubsignature(method, methods[i])) {
                return methods[i];
            }
            ++i;
        }
        return null;
    }

    public static IFunctionBinding findOverriddenMethodInHierarchy(ITypeBinding type, IFunctionBinding binding) {
        IFunctionBinding method = Bindings.findOverriddenMethodInType(type, binding);
        if (method != null) {
            return method;
        }
        ITypeBinding superClass = type.getSuperclass();
        if (superClass != null && (method = Bindings.findOverriddenMethodInHierarchy(superClass, binding)) != null) {
            return method;
        }
        return null;
    }

    public static IFunctionBinding findOverriddenMethod(IFunctionBinding overriding, boolean testVisibility) {
        IFunctionBinding res;
        ITypeBinding superType;
        int modifiers = overriding.getModifiers();
        if (Modifier.isPrivate(modifiers) || Modifier.isStatic(modifiers) || overriding.isConstructor()) {
            return null;
        }
        ITypeBinding type = overriding.getDeclaringClass();
        ITypeBinding iTypeBinding = superType = type != null ? type.getSuperclass() : null;
        if (!(superType == null || (res = Bindings.findOverriddenMethodInHierarchy(superType, overriding)) == null || Modifier.isPrivate(res.getModifiers()) || testVisibility && !Bindings.isVisibleInHierarchy(res, overriding.getDeclaringClass().getPackage()))) {
            return res;
        }
        return null;
    }

    public static boolean isVisibleInHierarchy(IFunctionBinding member, IPackageBinding pack) {
        int otherflags = member.getModifiers();
        if (Modifier.isPublic(otherflags) || Modifier.isProtected(otherflags)) {
            return true;
        }
        if (Modifier.isPrivate(otherflags)) {
            return false;
        }
        ITypeBinding declaringType = member.getDeclaringClass();
        return declaringType != null && pack == declaringType.getPackage();
    }

    public static ITypeBinding[] getAllSuperTypes(ITypeBinding type) {
        HashSet result = new HashSet();
        Bindings.collectSuperTypes(type, result);
        result.remove(type);
        return result.toArray(new ITypeBinding[result.size()]);
    }

    private static void collectSuperTypes(ITypeBinding curr, Set collection) {
        ITypeBinding superClass;
        if (collection.add(curr) && (superClass = curr.getSuperclass()) != null) {
            Bindings.collectSuperTypes(superClass, collection);
        }
    }

    public static boolean visitHierarchy(ITypeBinding type, TypeBindingVisitor visitor) {
        boolean result = Bindings.visitSuperclasses(type, visitor);
        return result;
    }

    public static boolean visitSuperclasses(ITypeBinding type, TypeBindingVisitor visitor) {
        while ((type = type.getSuperclass()) != null) {
            if (visitor.visit(type)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqualMethod(IFunctionBinding method, String methodName, ITypeBinding[] parameters) {
        if (!method.getName().equals(methodName)) {
            return false;
        }
        ITypeBinding[] methodParameters = method.getParameterTypes();
        if (methodParameters.length != parameters.length) {
            return false;
        }
        int i = 0;
        while (i < parameters.length) {
            if (!Bindings.equals(methodParameters[i].getErasure(), parameters[i].getErasure())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isSubsignature(IFunctionBinding overriding, IFunctionBinding overridden) {
        IBinding[] m2Params;
        if (!overriding.getName().equals(overridden.getName())) {
            return false;
        }
        IBinding[] m1Params = overriding.getParameterTypes();
        if (m1Params.length != (m2Params = overridden.getParameterTypes()).length) {
            return false;
        }
        if (Bindings.equals(m1Params, m2Params)) {
            return true;
        }
        int i = 0;
        while (i < m1Params.length) {
            IBinding m1Param = m1Params[i];
            if (!Bindings.equals(m1Param, m2Params[i].getErasure())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEqualMethod(IFunctionBinding method, String methodName, String[] parameters) {
        if (!method.getName().equals(methodName)) {
            return false;
        }
        ITypeBinding[] methodParameters = method.getParameterTypes();
        if (methodParameters.length != parameters.length) {
            return false;
        }
        int i = 0;
        while (i < parameters.length) {
            String second;
            String first = parameters[i];
            int index = first.indexOf(60);
            if (index > 0) {
                first = first.substring(0, index);
            }
            if ((index = (second = methodParameters[i].getErasure().getQualifiedName()).indexOf(60)) > 0) {
                second = second.substring(0, index);
            }
            if (!first.equals(second)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static ITypeBinding findTypeInHierarchy(ITypeBinding hierarchyType, String fullyQualifiedTypeName) {
        ITypeBinding res;
        if (hierarchyType.isArray() || hierarchyType.isPrimitive()) {
            return null;
        }
        if (fullyQualifiedTypeName.equals(hierarchyType.getQualifiedName())) {
            return hierarchyType;
        }
        ITypeBinding superClass = hierarchyType.getSuperclass();
        if (superClass != null && (res = Bindings.findTypeInHierarchy(superClass, fullyQualifiedTypeName)) != null) {
            return res;
        }
        return null;
    }

    public static IVariableBinding getAssignedVariable(Assignment assignment) {
        Expression leftHand = assignment.getLeftHandSide();
        switch (leftHand.getNodeType()) {
            case 42: {
                return (IVariableBinding)((SimpleName)leftHand).resolveBinding();
            }
            case 40: {
                return (IVariableBinding)((QualifiedName)leftHand).getName().resolveBinding();
            }
            case 22: {
                return ((FieldAccess)leftHand).resolveFieldBinding();
            }
            case 47: {
                return ((SuperFieldAccess)leftHand).resolveFieldBinding();
            }
        }
        return null;
    }

    public static boolean isSuperType(ITypeBinding possibleSuperType, ITypeBinding type) {
        if (type.isArray() || type.isPrimitive()) {
            return false;
        }
        if (Bindings.equals(type, possibleSuperType)) {
            return true;
        }
        ITypeBinding superClass = type.getSuperclass();
        return superClass != null && Bindings.isSuperType(possibleSuperType, superClass);
    }

    public static IJavaScriptUnit findCompilationUnit(ITypeBinding typeBinding, IJavaScriptProject project) throws JavaScriptModelException {
        IJavaScriptElement type = typeBinding.getJavaElement();
        if (type instanceof IType) {
            return ((IType)type).getJavaScriptUnit();
        }
        return null;
    }

    public static IFunction findMethod(IFunctionBinding method, IType type) throws JavaScriptModelException {
        method = method.getMethodDeclaration();
        IFunction[] candidates = type.getFunctions();
        int i = 0;
        while (i < candidates.length) {
            IFunction candidate = candidates[i];
            if (candidate.getElementName().equals(method.getName()) && Bindings.sameParameters(method, candidate)) {
                return candidate;
            }
            ++i;
        }
        return null;
    }

    private static boolean sameParameters(IFunctionBinding method, IFunction candidate) throws JavaScriptModelException {
        String[] candidateParameters;
        ITypeBinding[] methodParamters = method.getParameterTypes();
        if (methodParamters.length != (candidateParameters = candidate.getParameterTypes()).length) {
            return false;
        }
        IType scope = candidate.getDeclaringType();
        int i = 0;
        while (i < methodParamters.length) {
            ITypeBinding methodParameter = methodParamters[i];
            String candidateParameter = candidateParameters[i];
            if (!Bindings.sameParameter(methodParameter, candidateParameter, scope)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean sameParameter(ITypeBinding type, String candidate, IType scope) throws JavaScriptModelException {
        if (type.getDimensions() != Signature.getArrayCount(candidate)) {
            return false;
        }
        if (type.isArray()) {
            type = type.getElementType();
        }
        if (Signature.getTypeSignatureKind(candidate = Signature.getElementType(candidate)) == 2 != type.isPrimitive()) {
            return false;
        }
        if (type.isPrimitive()) {
            return type.getName().equals(Signature.toString(candidate));
        }
        type = type.getErasure();
        if (candidate.charAt(Signature.getArrayCount(candidate)) == 'L') {
            return Signature.toString(candidate).equals(Bindings.getFullyQualifiedName(type));
        }
        String[][] qualifiedCandidates = scope.resolveType(Signature.toString(candidate));
        if (qualifiedCandidates == null || qualifiedCandidates.length == 0) {
            return false;
        }
        String packageName = type.getPackage().isUnnamed() ? "" : type.getPackage().getName();
        String typeName = Bindings.getTypeQualifiedName(type);
        int i = 0;
        while (i < qualifiedCandidates.length) {
            String[] qualifiedCandidate = qualifiedCandidates[i];
            if (qualifiedCandidate[0].equals(packageName) && qualifiedCandidate[1].equals(typeName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static ITypeBinding normalizeTypeBinding(ITypeBinding binding) {
        if (binding != null && !binding.isNullType() && !Bindings.isVoidType(binding)) {
            if (binding.isAnonymous()) {
                return binding.getSuperclass();
            }
            return binding;
        }
        return null;
    }

    public static boolean isVoidType(ITypeBinding binding) {
        return "void".equals(binding.getName());
    }

    public static ITypeBinding normalizeForDeclarationUse(ITypeBinding binding, AST ast) {
        if (binding.isNullType()) {
            return ast.resolveWellKnownType("java.lang.Object");
        }
        if (binding.isPrimitive()) {
            return binding;
        }
        binding = Bindings.normalizeTypeBinding(binding);
        return binding;
    }

    public static ITypeBinding getBindingOfParentType(ASTNode node) {
        while (node != null) {
            if (node instanceof AbstractTypeDeclaration) {
                return ((AbstractTypeDeclaration)node).resolveBinding();
            }
            if (node instanceof AnonymousClassDeclaration) {
                return ((AnonymousClassDeclaration)node).resolveBinding();
            }
            if (node instanceof JavaScriptUnit) {
                return ((JavaScriptUnit)node).resolveBinding();
            }
            node = node.getParent();
        }
        return null;
    }

    public static ITypeBinding getBindingOfParentTypeContext(ASTNode node) {
        StructuralPropertyDescriptor lastLocation = null;
        while (node != null) {
            if (node instanceof AbstractTypeDeclaration) {
                AbstractTypeDeclaration decl = (AbstractTypeDeclaration)node;
                if (lastLocation == decl.getBodyDeclarationsProperty()) {
                    return decl.resolveBinding();
                }
            } else if (node instanceof AnonymousClassDeclaration) {
                return ((AnonymousClassDeclaration)node).resolveBinding();
            }
            lastLocation = node.getLocationInParent();
            node = node.getParent();
        }
        return null;
    }

    public static String getRawName(ITypeBinding binding) {
        String name = binding.getName();
        return name;
    }

    public static String getRawQualifiedName(ITypeBinding binding) {
        if (binding.isAnonymous() || binding.isLocal()) {
            return "";
        }
        if (binding.isPrimitive() || binding.isNullType()) {
            return binding.getName();
        }
        if (binding.isArray()) {
            String elementTypeQualifiedName = Bindings.getRawQualifiedName(binding.getElementType());
            if (elementTypeQualifiedName.length() != 0) {
                StringBuffer stringBuffer = new StringBuffer(elementTypeQualifiedName);
                stringBuffer.append('[').append(']');
                return stringBuffer.toString();
            }
            return "";
        }
        if (binding.isMember()) {
            String outerName = Bindings.getRawQualifiedName(binding.getDeclaringClass());
            if (outerName.length() > 0) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(outerName);
                buffer.append('.');
                buffer.append(Bindings.getRawName(binding));
                return buffer.toString();
            }
            return "";
        }
        if (binding.isTopLevel()) {
            IPackageBinding packageBinding = binding.getPackage();
            StringBuffer buffer = new StringBuffer();
            if (packageBinding != null && packageBinding.getName().length() > 0) {
                buffer.append(packageBinding.getName()).append('.');
            }
            buffer.append(Bindings.getRawName(binding));
            return buffer.toString();
        }
        return "";
    }

    public static boolean isDeclarationBinding(IBinding binding) {
        switch (binding.getKind()) {
            case 2: {
                return ((ITypeBinding)binding).getTypeDeclaration() == binding;
            }
            case 3: {
                return ((IVariableBinding)binding).getVariableDeclaration() == binding;
            }
            case 4: {
                return ((IFunctionBinding)binding).getMethodDeclaration() == binding;
            }
        }
        return true;
    }

    public static IBinding getDeclaration(IBinding binding) {
        switch (binding.getKind()) {
            case 2: {
                return ((ITypeBinding)binding).getTypeDeclaration();
            }
            case 3: {
                return ((IVariableBinding)binding).getVariableDeclaration();
            }
            case 4: {
                return ((IFunctionBinding)binding).getMethodDeclaration();
            }
        }
        return binding;
    }

    public static boolean containsSignatureEquivalentConstructor(IFunctionBinding[] candidates, IFunctionBinding overridable) {
        int index = 0;
        while (index < candidates.length) {
            if (Bindings.isSignatureEquivalentConstructor(candidates[index], overridable)) {
                return true;
            }
            ++index;
        }
        return false;
    }

    private static boolean isSignatureEquivalentConstructor(IFunctionBinding overridden, IFunctionBinding overridable) {
        if (!overridden.isConstructor() || !overridable.isConstructor()) {
            return false;
        }
        if (overridden.isDefaultConstructor()) {
            return false;
        }
        return Bindings.areSubTypeCompatible(overridden, overridable);
    }

    public static boolean areOverriddenMethods(IFunctionBinding overridden, IFunctionBinding overridable) {
        if (!overridden.getName().equals(overridable.getName())) {
            return false;
        }
        return Bindings.areSubTypeCompatible(overridden, overridable);
    }

    private static boolean areSubTypeCompatible(IFunctionBinding overridden, IFunctionBinding overridable) {
        ITypeBinding[] overridableTypes;
        if (overridden.getParameterTypes().length != overridable.getParameterTypes().length) {
            return false;
        }
        ITypeBinding overriddenReturn = overridden.getReturnType();
        ITypeBinding overridableReturn = overridable.getReturnType();
        if (overriddenReturn == null || overridableReturn == null) {
            return false;
        }
        if (!overriddenReturn.getErasure().isSubTypeCompatible(overridableReturn.getErasure())) {
            return false;
        }
        ITypeBinding[] overriddenTypes = overridden.getParameterTypes();
        Assert.isTrue((overriddenTypes.length == (overridableTypes = overridable.getParameterTypes()).length ? 1 : 0) != 0);
        int index = 0;
        while (index < overriddenTypes.length) {
            ITypeBinding overriddenErasure;
            ITypeBinding overridableErasure = overridableTypes[index].getErasure();
            if (!overridableErasure.isSubTypeCompatible(overriddenErasure = overriddenTypes[index].getErasure()) || !overridableErasure.getKey().equals(overriddenErasure.getKey())) {
                return false;
            }
            ++index;
        }
        return true;
    }
}

