/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.validate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;
import org.eclipse.wst.html.core.internal.Logger;
import org.eclipse.wst.html.core.internal.contentmodel.HTMLPropertyDeclaration;
import org.eclipse.wst.html.core.internal.document.HTMLDocumentTypeEntry;
import org.eclipse.wst.html.core.internal.document.HTMLDocumentTypeRegistry;
import org.eclipse.wst.html.core.internal.validate.AbstractErrorInfo;
import org.eclipse.wst.html.core.internal.validate.CMUtil;
import org.eclipse.wst.html.core.internal.validate.CustomHTMLTagValidatorExtensionLoader;
import org.eclipse.wst.html.core.internal.validate.ErrorInfoImpl;
import org.eclipse.wst.html.core.internal.validate.ErrorState;
import org.eclipse.wst.html.core.internal.validate.FMUtil;
import org.eclipse.wst.html.core.internal.validate.PrimeValidator;
import org.eclipse.wst.html.core.internal.validate.Segment;
import org.eclipse.wst.html.core.internal.validate.StringMatcher;
import org.eclipse.wst.html.core.validate.extension.IHTMLCustomTagValidator;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.validate.ValidationMessage;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.document.InvalidCharacterException;
import org.eclipse.wst.xml.core.internal.document.SourceValidator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class SyntaxValidator
extends PrimeValidator
implements ErrorState {
    private IPreferencesService fPreferenceService = Platform.getPreferencesService();
    private static Map fIgnorePatterns = new HashMap();
    private List<IHTMLCustomTagValidator> externalValidators;

    private static boolean isValidRegion(ITextRegion rgn) {
        String type = rgn.getType();
        if (type == null) {
            return false;
        }
        return type == "XML_END_TAG_OPEN" || type == "XML_TAG_NAME" || type == "XML_TAG_CLOSE";
    }

    private static String getTagName(IStructuredDocumentRegion tag) {
        ITextRegionList regions = tag.getRegions();
        Iterator<ITextRegion> iter = regions.iterator();
        while (iter.hasNext()) {
            ITextRegion rgn = iter.next();
            if (rgn.getType() != "XML_TAG_NAME") continue;
            return tag.getText(rgn);
        }
        return "";
    }

    private static boolean isEmptyContent(CMElementDeclaration decl) {
        return decl != null && decl.getContentType() == 1;
    }

    @Override
    public boolean isAdapterForType(Object type) {
        return type == SyntaxValidator.class || super.isAdapterForType(type);
    }

    @Override
    public void validate(IndexedRegion indexedNode) {
        Node node = (Node)((Object)indexedNode);
        this.validateChildren(node);
        if (node.getNodeType() != 1) {
            return;
        }
        if (!(node instanceof IDOMElement)) {
            return;
        }
        ElementInfo info = new ElementInfo();
        info.target = (IDOMElement)node;
        if (info.target.getModel().isModelStateChanging()) {
            return;
        }
        this.getInfo(info);
        this.validateTags(info);
        if (info.target.isGlobalTag()) {
            this.validateNames(info);
            if (info.decl != null && info.isXHTML) {
                this.validateTagCase(info);
            }
        }
        this.validateAttributes(info);
    }

    private void getInfo(ElementInfo info) {
        info.decl = CMUtil.getDeclaration(info.target);
        info.startTag = info.target.getStartStructuredDocumentRegion();
        info.endTag = info.target.getEndStructuredDocumentRegion();
        Document doc = info.target.getOwnerDocument();
        if (!(doc instanceof IDOMDocument)) {
            return;
        }
        String typeid = ((IDOMDocument)doc).getDocumentTypeId();
        if (typeid != null) {
            if (typeid.trim().length() != 0) {
                HTMLDocumentTypeEntry entry = HTMLDocumentTypeRegistry.getInstance().getEntry(typeid);
                info.isXHTML = entry != null && entry.isXMLType();
            } else {
                info.isXHTML5 = info.isXHTML = this.getXMLTarget(doc);
            }
        }
    }

    private boolean getXMLTarget(Document doc) {
        if (doc == null) {
            return false;
        }
        Node child = doc.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1 && child.getNodeName().equalsIgnoreCase("html")) {
                if (child.getAttributes() != null) {
                    NamedNodeMap attrs = child.getAttributes();
                    int i = 0;
                    while (i < attrs.getLength()) {
                        Attr a = (Attr)attrs.item(i);
                        if (a.getName().equalsIgnoreCase("xmlns")) {
                            return true;
                        }
                        ++i;
                    }
                }
                return false;
            }
            child = child.getNextSibling();
        }
        return false;
    }

    private boolean isEndTagCorrupted(ElementInfo info) {
        ITextRegionList regions = info.endTag.getRegions();
        if (regions == null || regions.isEmpty()) {
            return false;
        }
        Iterator<ITextRegion> iter = regions.iterator();
        while (iter.hasNext()) {
            ITextRegion rgn = iter.next();
            if (SyntaxValidator.isValidRegion(rgn)) continue;
            return true;
        }
        return false;
    }

    private String getEndTagFullText(ElementInfo info) {
        String hint = "";
        ITextRegionList regions = info.endTag.getRegions();
        Iterator<ITextRegion> iter = regions.iterator();
        while (iter.hasNext()) {
            ITextRegion rgn = iter.next();
            String type = rgn.getType();
            if (type == null || type == "XML_END_TAG_OPEN" || type == "XML_TAG_CLOSE") continue;
            hint = String.valueOf(hint) + info.endTag.getFullText(rgn);
        }
        return hint;
    }

    private void reportCorruptedEndTagError(ElementInfo info) {
        String hint = this.getEndTagFullText(info);
        TagErrorInfoImpl error = new TagErrorInfoImpl(11, info.endTag, hint);
        this.reporter.report(error);
    }

    private void validateTags(ElementInfo info) {
        if (info.hasStartTag()) {
            if (!info.target.isStartTagClosed()) {
                Segment errorSeg = new Segment(info.startTag);
                this.report(110, errorSeg, info.target);
            }
        } else if (info.hasEndTag() && info.decl != null) {
            if (info.isXHTML) {
                Segment errorSeg = FMUtil.getSegment(info.target, 5);
                this.report(105, errorSeg, info.target);
            } else {
                boolean canOmitStartTag = false;
                if (info.decl instanceof HTMLPropertyDeclaration) {
                    int omitType = ((HTMLPropertyDeclaration)((Object)info.decl)).getOmitType();
                    boolean bl = canOmitStartTag = omitType == 1;
                }
                if (!canOmitStartTag && !info.target.hasChildNodes()) {
                    if (info.target.isContainer()) {
                        Segment errorSeg = FMUtil.getSegment(info.target, 3);
                        this.report(105, errorSeg, info.target);
                    } else {
                        Segment errorSeg = new Segment(info.endTag);
                        this.report(107, errorSeg, info.target);
                    }
                }
            }
        }
        if (info.hasEndTag()) {
            if (!info.target.isClosed()) {
                Segment errorSeg = new Segment(info.endTag);
                this.report(111, errorSeg, info.target);
            }
        } else if (info.isXHTML) {
            IStructuredDocumentRegion structRegion = info.target.getStartStructuredDocumentRegion();
            if (!info.target.isEmptyTag() && structRegion != null && "XML_TAG_OPEN".equals(structRegion.getFirstRegion().getType())) {
                if (SyntaxValidator.isEmptyContent(info.decl)) {
                    Segment errorSeg = FMUtil.getSegment(info.target, 2);
                    this.report(112, errorSeg, info.target);
                } else {
                    Segment errorSeg = FMUtil.getSegment(info.target, 2);
                    this.report(106, errorSeg, info.target);
                }
            }
        } else if (info.hasStartTag() && info.decl != null && CMUtil.isHTML(info.decl) && !info.target.isEmptyTag() && !CMUtil.isEndTagOmissible(info.decl) && "XML_TAG_OPEN".equals(info.startTag.getFirstRegion().getType())) {
            Segment errorSeg = FMUtil.getSegment(info.target, 2);
            this.report(106, errorSeg, info.target);
        }
    }

    private void validateNames(ElementInfo info) {
        boolean corrupted;
        boolean bl = corrupted = info.hasEndTag() && this.isEndTagCorrupted(info);
        if (info.decl == null) {
            if (!info.hasStartTag() && corrupted) {
                this.reportCorruptedEndTagError(info);
            } else if (this.shouldValidateElementName(info.target)) {
                boolean validated = false;
                if (this.externalValidators == null) {
                    this.initValidators(info.target.getStructuredDocument());
                }
                for (IHTMLCustomTagValidator v : this.externalValidators) {
                    try {
                        if (!v.canValidate(info.target)) continue;
                        validated = true;
                        ValidationMessage result = v.validateTag(info.target);
                        if (result == null) continue;
                        this.reporter.report(result);
                        break;
                    }
                    catch (Throwable t) {
                        Logger.logException(t);
                    }
                }
                if (!validated) {
                    Segment errorSeg = FMUtil.getSegment(info.target, 4);
                    this.report(11, errorSeg, info.target);
                }
            }
        } else if (corrupted) {
            this.reportCorruptedEndTagError(info);
        }
    }

    private void initValidators(IStructuredDocument doc) {
        this.externalValidators = new ArrayList<IHTMLCustomTagValidator>();
        for (IConfigurationElement e : CustomHTMLTagValidatorExtensionLoader.getInstance().getValidators()) {
            try {
                IHTMLCustomTagValidator validator = (IHTMLCustomTagValidator)e.createExecutableExtension("class");
                validator.init(doc);
                this.externalValidators.add(validator);
            }
            catch (CoreException e1) {
                Logger.logException(e1);
            }
        }
    }

    private boolean shouldValidateElementName(Element target) {
        Object adapter = target instanceof IAdaptable ? ((IAdaptable)target).getAdapter(IResource.class) : null;
        IProject project = adapter instanceof IResource ? ((IResource)adapter).getProject() : null;
        for (String excluded : this.getExcludedElementNames(project)) {
            StringMatcher strMatcher = (StringMatcher)fIgnorePatterns.get(excluded);
            if (strMatcher == null) {
                strMatcher = new StringMatcher(excluded);
                fIgnorePatterns.put(excluded, strMatcher);
            }
            if (!strMatcher.match(target.getNodeName())) continue;
            return false;
        }
        return true;
    }

    private Set getExcludedElementNames(IProject project) {
        ProjectScope projectScope;
        IScopeContext[] fLookupOrder = new IScopeContext[]{new InstanceScope(), new DefaultScope()};
        if (project != null && (projectScope = new ProjectScope(project)).getNode(HTMLCorePlugin.getDefault().getBundle().getSymbolicName()).getBoolean("use-project-settings", false)) {
            fLookupOrder = new IScopeContext[]{projectScope, new InstanceScope(), new DefaultScope()};
        }
        HashSet<String> result = new HashSet<String>();
        if (this.fPreferenceService.getBoolean(HTMLCorePlugin.getDefault().getBundle().getSymbolicName(), "ignoreElementNames", false, fLookupOrder)) {
            String ignoreList = this.fPreferenceService.getString(HTMLCorePlugin.getDefault().getBundle().getSymbolicName(), "elementNamesToIgnore", "", fLookupOrder);
            if (ignoreList.trim().length() == 0) {
                return result;
            }
            String[] names = ignoreList.split(",");
            int i = 0;
            while (names != null && i < names.length) {
                String name;
                String string = name = names[i] == null ? null : names[i].trim();
                if (name != null && name.length() > 0) {
                    result.add(name.toLowerCase());
                }
                ++i;
            }
        }
        return result;
    }

    private void validateTagCase(ElementInfo info) {
        String declared = info.decl.getElementName();
        String startTagName = "";
        String endTagName = "";
        if (declared == null) {
            return;
        }
        if (info.isXHTML5) {
            if (info.hasStartTag()) {
                startTagName = SyntaxValidator.getTagName(info.startTag);
                if (info.hasEndTag() && !(endTagName = SyntaxValidator.getTagName(info.endTag)).equals(startTagName)) {
                    TagErrorInfoImpl error = new TagErrorInfoImpl(103, info.endTag, endTagName);
                    this.reporter.report(error);
                }
            }
        } else {
            TagErrorInfoImpl error;
            if (info.hasStartTag() && !declared.equals(startTagName = SyntaxValidator.getTagName(info.startTag))) {
                error = new TagErrorInfoImpl(103, info.startTag, startTagName);
                this.reporter.report(error);
            }
            if (info.hasEndTag()) {
                endTagName = SyntaxValidator.getTagName(info.endTag);
                if (!(info.hasStartTag() && endTagName.equals(startTagName) || declared.equals(endTagName))) {
                    error = new TagErrorInfoImpl(103, info.endTag, endTagName);
                    this.reporter.report(error);
                }
            }
        }
    }

    private void validateChildren(Node target) {
        if (target.getNodeType() == 1 && CMUtil.isForeign((Element)target)) {
            return;
        }
        Node child = target.getFirstChild();
        while (child != null) {
            switch (child.getNodeType()) {
                case 3: {
                    Segment errorSeg;
                    IDOMNode text = (IDOMNode)child;
                    int charOffset = this.validateTextSource(text);
                    if (charOffset < 0 || (errorSeg = new Segment(charOffset += text.getStartOffset(), 1)) == null) break;
                    this.report(102, errorSeg, text);
                    break;
                }
                case 4: 
                case 7: 
                case 8: 
                case 10: {
                    Segment errorSeg;
                    IDOMNode tag = (IDOMNode)child;
                    if (tag.isClosed() || (errorSeg = FMUtil.getSegment(tag, 1)) == null) break;
                    this.report(110, errorSeg, tag);
                    break;
                }
            }
            child = child.getNextSibling();
        }
    }

    private int validateTextSource(IDOMNode text) {
        try {
            SourceValidator validator = new SourceValidator(text);
            validator.validateSource(text.getSource());
        }
        catch (InvalidCharacterException ex) {
            return ex.getOffset();
        }
        return -1;
    }

    private void validateAttributes(ElementInfo info) {
        if (info != null && info.hasStartTag()) {
            ITextRegionList list = info.startTag.getRegions();
            int i = 0;
            while (i < list.size()) {
                ITextRegion region = list.get(i);
                String type = region.getType();
                if (type == "UNDEFINED") {
                    String invalidText = info.startTag.getFullText(region).trim();
                    Segment errorSeg = new Segment(info.startTag.getStartOffset() + region.getStart(), invalidText.length());
                    this.report(115, errorSeg, info.target, new String[]{invalidText}, new String[0]);
                }
                ++i;
            }
        }
    }

    private void report(int state, Segment errorSeg, Node node) {
        ErrorInfoImpl info = new ErrorInfoImpl(state, errorSeg, node);
        this.reporter.report(info);
    }

    private void report(int state, Segment errorSeg, Node node, String[] preTargetMsgInjections, String[] postTargetMsgInjections) {
        ErrorInfoImpl info = new ErrorInfoImpl(state, errorSeg, node, preTargetMsgInjections, postTargetMsgInjections);
        this.reporter.report(info);
    }

    class ElementInfo {
        public IDOMElement target = null;
        public CMElementDeclaration decl = null;
        public IStructuredDocumentRegion startTag = null;
        public IStructuredDocumentRegion endTag = null;
        public boolean isXHTML = false;
        public boolean isXHTML5 = false;

        public boolean hasStartTag() {
            return this.startTag != null;
        }

        public boolean hasEndTag() {
            return this.endTag != null;
        }
    }

    class TagErrorInfoImpl
    extends AbstractErrorInfo {
        private String hint;

        public TagErrorInfoImpl(int state, IStructuredDocumentRegion tag, String hint) {
            super(state, new Segment(tag));
            this.hint = null;
            this.hint = hint;
        }

        @Override
        public String getHint() {
            return this.hint;
        }

        @Override
        public short getTargetType() {
            return 1;
        }
    }
}

