/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.dtd.core.internal.Attribute;
import org.eclipse.wst.dtd.core.internal.AttributeEnumList;
import org.eclipse.wst.dtd.core.internal.AttributeList;
import org.eclipse.wst.dtd.core.internal.CMBasicNode;
import org.eclipse.wst.dtd.core.internal.DTDFile;
import org.eclipse.wst.dtd.core.internal.DTDNode;
import org.eclipse.wst.dtd.core.internal.Element;
import org.eclipse.wst.dtd.core.internal.Entity;
import org.eclipse.wst.dtd.core.internal.Notation;
import org.eclipse.wst.dtd.core.internal.ParameterEntityReference;
import org.eclipse.wst.dtd.core.internal.util.DTDVisitor;

public class DTDReferenceUpdater
extends DTDVisitor {
    protected boolean isNotation = false;
    protected boolean isParmEntity = false;
    protected boolean isUpdating = false;
    protected String newName = "";
    protected String oldRefName = "";
    protected String newRefName = "";
    protected DTDNode referencedNode = null;
    private List references = new ArrayList();
    protected Object requestor;

    public void clearCache() {
        this.referencedNode = null;
        this.references.clear();
    }

    public synchronized void nameAboutToChange(Object requestor, DTDNode referencedNode, String newName) {
        if (this.isUpdating) {
            return;
        }
        if (!(referencedNode instanceof Entity || referencedNode instanceof Element || referencedNode instanceof Notation)) {
            return;
        }
        if (referencedNode instanceof Entity && !((Entity)referencedNode).isParameterEntity()) {
            return;
        }
        this.isUpdating = true;
        this.requestor = requestor;
        this.oldRefName = referencedNode.getName();
        this.newName = this.newRefName = newName;
        this.isParmEntity = false;
        this.isNotation = referencedNode instanceof Notation;
        if (referencedNode instanceof Entity) {
            this.isParmEntity = true;
            this.oldRefName = "%" + this.oldRefName + ";";
            this.newRefName = "%" + this.newRefName + ";";
        }
        if (this.referencedNode != null && this.referencedNode == referencedNode) {
            this.quickUpdate();
            this.isUpdating = false;
            return;
        }
        this.referencedNode = referencedNode;
        this.references.clear();
        DTDFile dtdFile = referencedNode.getDTDFile();
        this.visit(dtdFile);
        this.isUpdating = false;
    }

    protected void quickUpdate() {
        int i = 0;
        while (i < this.references.size()) {
            DTDNode node = (DTDNode)this.references.get(i);
            if (node instanceof Element) {
                this.visitElement((Element)node);
            } else if (node instanceof AttributeList) {
                this.visitAttributeList((AttributeList)node);
            } else if (node instanceof Attribute) {
                this.visitAttribute((Attribute)node);
            } else if (node instanceof CMBasicNode) {
                this.visitReference((CMBasicNode)node);
            } else if (node instanceof ParameterEntityReference) {
                this.visitExternalParameterEntityReference((ParameterEntityReference)node);
            }
            ++i;
        }
    }

    @Override
    public void visitAttribute(Attribute attr) {
        super.visitAttribute(attr);
        if (this.isParmEntity) {
            if (attr.getName().equals(this.oldRefName)) {
                attr.setName(this.requestor, this.newRefName);
                this.references.add(attr);
            }
            if (attr.getType().equals(this.oldRefName)) {
                attr.setType(this.requestor, this.newRefName);
                this.references.add(attr);
            }
        } else if (this.isNotation && attr.getType().equals(Attribute.ENUMERATED_NOTATION)) {
            AttributeEnumList enumList = attr.getEnumList();
            List items = enumList.getItems();
            boolean updateNeeded = false;
            int i = 0;
            while (i < items.size()) {
                String notationName = (String)items.get(i);
                if (notationName.equals(this.oldRefName)) {
                    updateNeeded = true;
                    items.set(i, this.newName);
                }
                ++i;
            }
            if (updateNeeded) {
                String[] newItems = new String[items.size()];
                enumList.setItems(items.toArray(newItems));
            }
        }
    }

    @Override
    public void visitAttributeList(AttributeList attList) {
        if (!this.isNotation && attList.getName().equals(this.oldRefName)) {
            attList.setName(this.requestor, this.newRefName);
            this.references.add(attList);
        }
        super.visitAttributeList(attList);
    }

    @Override
    public void visitElement(Element element) {
        if (this.isParmEntity && element.getName().equals(this.oldRefName)) {
            element.setName(this.requestor, this.newRefName);
            this.references.add(element);
        }
        super.visitElement(element);
    }

    @Override
    public void visitExternalParameterEntityReference(ParameterEntityReference parmEntityRef) {
        super.visitExternalParameterEntityReference(parmEntityRef);
        if (parmEntityRef.getName().equals(this.oldRefName)) {
            parmEntityRef.setReferencedEntity(this.requestor, this.newName);
            this.references.add(parmEntityRef);
        }
    }

    @Override
    public void visitReference(CMBasicNode node) {
        super.visitReference(node);
        if (this.isParameterEntityRef(this.oldRefName) && !this.isParmEntity) {
            return;
        }
        if (node.getName().equals(this.oldRefName)) {
            node.setName(this.requestor, this.newRefName);
            this.references.add(node);
        }
    }
}

