/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal.parser;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.wst.dtd.core.internal.parser.DTDRegionFactory;
import org.eclipse.wst.dtd.core.internal.text.DTDStructuredDocumentRegionFactory;
import org.eclipse.wst.dtd.core.internal.tokenizer.DTDTokenizer;
import org.eclipse.wst.dtd.core.internal.tokenizer.Token;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class DTDRegionParser
implements RegionParser {
    private Vector cachedRegions = null;
    private DTDTokenizer tokenizer = null;
    private IStructuredDocumentRegion cachedNode = null;

    @Override
    public RegionParser newInstance() {
        return new DTDRegionParser();
    }

    private IStructuredDocumentRegion addNewNodes(IStructuredDocumentRegion lastNode, Vector regions) {
        String type;
        ITextRegion region;
        IStructuredDocumentRegion leadingSpaceNode = null;
        IStructuredDocumentRegion contentNode = null;
        IStructuredDocumentRegion trailingSpaceNode = null;
        LinkedList<ITextRegion> nodeSeeds = new LinkedList<ITextRegion>();
        int nRegions = regions.size();
        int leadingSpaceEnd = -1;
        int trailingSpaceBegin = nRegions;
        nodeSeeds.clear();
        int i = 0;
        while (i < nRegions) {
            region = (ITextRegion)regions.get(i);
            type = region.getType();
            if (!this.isBlankRegion(type)) break;
            leadingSpaceEnd = i++;
            nodeSeeds.addLast(region);
        }
        if (!nodeSeeds.isEmpty()) {
            leadingSpaceNode = this.createNode(nodeSeeds);
            if (lastNode != null) {
                lastNode.setNext(leadingSpaceNode);
                leadingSpaceNode.setPrevious(lastNode);
            }
            lastNode = leadingSpaceNode;
        }
        if (leadingSpaceEnd < nRegions - 1) {
            nodeSeeds.clear();
            i = nRegions - 1;
            while (i >= 0) {
                region = (ITextRegion)regions.get(i);
                type = ((ITextRegion)regions.get(i)).getType();
                if (!this.isBlankRegion(type)) break;
                trailingSpaceBegin = i--;
                nodeSeeds.addFirst(region);
            }
            if (!nodeSeeds.isEmpty()) {
                trailingSpaceNode = this.createNode(nodeSeeds);
            }
            nodeSeeds.clear();
            i = leadingSpaceEnd + 1;
            while (i < trailingSpaceBegin) {
                nodeSeeds.addLast((ITextRegion)regions.get(i));
                ++i;
            }
            if (!nodeSeeds.isEmpty()) {
                contentNode = this.createNode(nodeSeeds);
                if (lastNode != null) {
                    lastNode.setNext(contentNode);
                    contentNode.setPrevious(lastNode);
                }
                lastNode = contentNode;
            }
            if (trailingSpaceNode != null) {
                lastNode.setNext(trailingSpaceNode);
                trailingSpaceNode.setPrevious(lastNode);
                lastNode = trailingSpaceNode;
            }
        }
        return lastNode;
    }

    private IStructuredDocumentRegion createNode(LinkedList regions) {
        if (regions.size() == 0) {
            return null;
        }
        IStructuredDocumentRegion node = DTDStructuredDocumentRegionFactory.createStructuredDocumentRegion(5);
        int start = ((ITextRegion)regions.getFirst()).getStart();
        int length = ((ITextRegion)regions.getLast()).getEnd() - start;
        node.setStart(start);
        node.setLength(length);
        ListIterator i = regions.listIterator(0);
        while (i.hasNext()) {
            ITextRegion region = (ITextRegion)i.next();
            node.addRegion(region);
            region.adjustStart(-start);
        }
        node.setEnded(true);
        return node;
    }

    private IStructuredDocumentRegion createNodeChain(List regions) {
        IStructuredDocumentRegion headNode = null;
        IStructuredDocumentRegion lastNode = null;
        Vector<ITextRegion> nodeSeeds = new Vector<ITextRegion>();
        for (ITextRegion region : regions) {
            String type = region.getType();
            if (!nodeSeeds.isEmpty() && this.isBeginningRegion(type)) {
                lastNode = this.addNewNodes(lastNode, nodeSeeds);
                nodeSeeds.clear();
            }
            nodeSeeds.addElement(region);
            if (!nodeSeeds.isEmpty() && this.isEndingRegion(type)) {
                lastNode = this.addNewNodes(lastNode, nodeSeeds);
                nodeSeeds.clear();
            }
            if (headNode != null || lastNode == null) continue;
            headNode = this.findFirstNode(lastNode);
        }
        if (!nodeSeeds.isEmpty()) {
            lastNode = this.addNewNodes(lastNode, nodeSeeds);
            if (headNode == null && lastNode != null) {
                headNode = this.findFirstNode(lastNode);
            }
        }
        return headNode;
    }

    private IStructuredDocumentRegion findFirstNode(IStructuredDocumentRegion node) {
        IStructuredDocumentRegion firstNode = node;
        IStructuredDocumentRegion prevNode = null;
        while ((prevNode = firstNode.getPrevious()) != null) {
            firstNode = prevNode;
        }
        return firstNode;
    }

    @Override
    public IStructuredDocumentRegion getDocumentRegions() {
        IStructuredDocumentRegion headNode;
        if (this.cachedNode != null) {
            return this.cachedNode;
        }
        List regions = this.getRegions();
        this.cachedNode = headNode = this.createNodeChain(regions);
        return headNode;
    }

    @Override
    public List getRegions() {
        if (this.cachedRegions != null) {
            return this.cachedRegions;
        }
        Vector<ITextRegion> regions = new Vector<ITextRegion>();
        Token currentToken = null;
        do {
            try {
                currentToken = (Token)this.tokenizer.yylex();
                if (currentToken == null) continue;
                ITextRegion region = DTDRegionFactory.createRegion(currentToken.getType(), currentToken.getStartOffset(), currentToken.getLength());
                regions.add(region);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("File not found");
            }
            catch (IOException iOException) {
                System.out.println("Error opening file");
            }
        } while (currentToken != null);
        this.cachedRegions = regions;
        return regions;
    }

    @Override
    public void reset(Reader reader) {
        if (this.tokenizer == null) {
            try {
                this.tokenizer = new DTDTokenizer(reader);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println("Usage : java DTDTokenizer <inputfile>");
            }
        } else {
            try {
                this.tokenizer.yyreset(reader);
            }
            catch (IOException iOException) {
                System.out.println("Error opening file");
            }
        }
        this.cachedNode = null;
        this.cachedRegions = null;
    }

    @Override
    public void reset(Reader reader, int offset) {
        this.reset(reader);
    }

    @Override
    public void reset(String input) {
        this.reset(new StringReader(input));
    }

    @Override
    public void reset(String input, int offset) {
        this.reset(input);
    }

    DTDTokenizer getTokenizer() {
        return this.tokenizer;
    }

    private boolean isBeginningRegion(String type) {
        return type == "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.START_TAG" || type == "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ENTITY_PARM";
    }

    private boolean isBlankRegion(String type) {
        return type == "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.WHITESPACE";
    }

    private boolean isEndingRegion(String type) {
        return type == "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.END_TAG" || type == "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ENTITY_PARM" || type == "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.COMMENT_END";
    }
}

