/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.eclipse.wtp.sse;

import com.diffplug.spotless.extra.eclipse.base.service.NoContentTypeSpecificHandling;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeSettings;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.wst.css.core.internal.provisional.contenttype.ContentTypeIdForCSS;
import org.eclipse.wst.html.core.internal.provisional.contenttype.ContentTypeIdForHTML;
import org.eclipse.wst.json.core.contenttype.ContentTypeIdForJSON;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;

class ContentTypeManager
extends NoContentTypeSpecificHandling {
    private final Map<String, IContentType> id2Object = new HashMap<String, IContentType>();
    private final IContentType processorStepType;
    private final IContentDescription processorStepDescription;

    ContentTypeManager(String formatterContentTypeID) {
        Arrays.asList(ContentTypeIdForCSS.ContentTypeID_CSS, ContentTypeIdForXML.ContentTypeID_XML, ContentTypeIdForHTML.ContentTypeID_HTML, ContentTypeIdForJSON.ContentTypeID_JSON).stream().forEach(id -> this.id2Object.put((String)id, new ContentTypeId((String)id)));
        this.processorStepType = this.id2Object.get(formatterContentTypeID);
        if (null == this.processorStepType) {
            throw new IllegalArgumentException("The manager does not support content type " + formatterContentTypeID);
        }
        this.processorStepDescription = new StringDescription(this.processorStepType);
    }

    public IContentType getContentType(String contentTypeIdentifier) {
        return this.id2Object.get(contentTypeIdentifier);
    }

    public IContentType findContentTypeFor(InputStream contents, String fileName) throws IOException {
        return this.processorStepType;
    }

    public IContentDescription getDescriptionFor(InputStream contents, String fileName, QualifiedName[] options) throws IOException {
        return this.processorStepDescription;
    }

    private static class ContentTypeId
    implements IContentType {
        private final String id;

        ContentTypeId(String id) {
            this.id = id;
        }

        public void addFileSpec(String fileSpec, int type) throws CoreException {
        }

        public void removeFileSpec(String fileSpec, int type) throws CoreException {
        }

        public void setDefaultCharset(String userCharset) throws CoreException {
        }

        public boolean isUserDefined() {
            return false;
        }

        public IContentType getBaseType() {
            return null;
        }

        public IContentDescription getDefaultDescription() {
            return null;
        }

        public IContentDescription getDescriptionFor(InputStream contents, QualifiedName[] options) throws IOException {
            return null;
        }

        public IContentDescription getDescriptionFor(Reader contents, QualifiedName[] options) throws IOException {
            return null;
        }

        public String getDefaultCharset() {
            return null;
        }

        public String[] getFileSpecs(int type) {
            return null;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.id;
        }

        public boolean isAssociatedWith(String fileName) {
            return false;
        }

        public boolean isAssociatedWith(String fileName, IScopeContext context) {
            return false;
        }

        public boolean isKindOf(IContentType another) {
            if (null == another) {
                return false;
            }
            return this.id.equals(another.getId());
        }

        public IContentTypeSettings getSettings(IScopeContext context) throws CoreException {
            return null;
        }
    }

    private static class StringDescription
    implements IContentDescription {
        private final IContentType type;

        public StringDescription(IContentType type) {
            this.type = type;
        }

        public boolean isRequested(QualifiedName key) {
            return false;
        }

        public String getCharset() {
            return "UTF-8";
        }

        public IContentType getContentType() {
            return this.type;
        }

        public Object getProperty(QualifiedName key) {
            return null;
        }

        public void setProperty(QualifiedName key, Object value) {
            throw new IllegalArgumentException("Content description key cannot be set: " + key);
        }
    }
}

