/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.internal.format;

import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.json.core.cleanup.IJSONCleanupStrategy;
import org.eclipse.wst.json.core.document.IJSONArray;
import org.eclipse.wst.json.core.document.IJSONNode;
import org.eclipse.wst.json.core.document.IJSONObject;
import org.eclipse.wst.json.core.internal.format.AbstractJSONSourceFormatter;
import org.eclipse.wst.json.core.internal.format.CompoundRegion;
import org.eclipse.wst.json.core.internal.format.FormatRegion;
import org.eclipse.wst.json.core.internal.format.IJSONSourceFormatter;
import org.eclipse.wst.json.core.internal.format.JSONSourceFormatterFactory;
import org.eclipse.wst.json.core.internal.format.JSONStructureFormatter;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;

public class JSONArrayFormatter
extends JSONStructureFormatter {
    private static JSONArrayFormatter instance;

    JSONArrayFormatter() {
    }

    @Override
    protected void formatChildren(IJSONNode node, StringBuilder source) {
        if (node instanceof IJSONArray) {
            IJSONArray array = (IJSONArray)node;
            IJSONNode child = array.getFirstChild();
            while (child != null) {
                if (child instanceof IJSONObject || child instanceof IJSONArray) {
                    this.formatObject(node, source, child);
                    if (child.getNextSibling() != null) {
                        int start = child.getEndOffset();
                        int end = child.getNextSibling().getStartOffset();
                        if (end > start) {
                            IJSONCleanupStrategy stgy = this.getCleanupStrategy(node);
                            IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
                            CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, new FormatRegion(start, end - start), stgy);
                            int i = 0;
                            while (i < regions.length) {
                                source.append(this.decoratedRegion(regions[i], 0, stgy));
                                ++i;
                            }
                        }
                    }
                    String delim = this.getLineDelimiter(node);
                    source.append(delim);
                    source.append(this.getIndent(node));
                } else {
                    this.formatValue(node, source, child);
                }
                child = child.getNextSibling();
                if (child == null) continue;
                source.append(this.getIndentString());
            }
        }
    }

    @Override
    protected void formatValue(IJSONNode node, StringBuilder source, IJSONNode value) {
        int e;
        int s;
        CompoundRegion[] regions;
        IJSONCleanupStrategy stgy = this.getCleanupStrategy(node);
        IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
        int start = value.getStartOffset();
        int end = value.getEndOffset();
        if (value.getNextSibling() != null && (regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, new FormatRegion(s = value.getEndOffset(), (e = value.getNextSibling().getStartOffset()) - s), stgy)).length > 0) {
            ++end;
        }
        CompoundRegion[] regions2 = this.getRegionsWithoutWhiteSpaces(structuredDocument, new FormatRegion(start, end - start), stgy);
        int i = 0;
        while (i < regions2.length) {
            source.append(this.decoratedRegion(regions2[i], 0, stgy));
            ++i;
        }
        source.append(this.getLineDelimiter(node));
        source.append(this.getIndent(node));
    }

    @Override
    protected void formatObject(IJSONNode node, StringBuilder source, IJSONNode jsonObject) {
        this.getCleanupStrategy(node);
        IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
        IStructuredDocumentRegion[] structuredRegions = structuredDocument.getStructuredDocumentRegions(node.getStartOffset(), node.getEndOffset());
        if (structuredRegions.length >= 2) {
            StringBuilder objectSource;
            int start = structuredRegions[1].getStartOffset();
            int end = node.getEndOffset();
            IJSONSourceFormatter formatter = (IJSONSourceFormatter)((Object)jsonObject.getAdapterFor(IJSONSourceFormatter.class));
            if (formatter == null) {
                formatter = JSONSourceFormatterFactory.getInstance().getSourceFormatter(jsonObject);
            }
            if ((objectSource = formatter.format(jsonObject, new FormatRegion(start, end - start))) != null) {
                source.append((CharSequence)objectSource);
            }
        }
    }

    @Override
    protected void formatChildren(IJSONNode node, IRegion region, StringBuilder source) {
        IJSONNode child = node.getFirstChild();
        int start = region.getOffset();
        int end = region.getOffset() + region.getLength();
        while (child != null) {
            int curEnd = child.getEndOffset();
            StringBuilder childSource = null;
            boolean toFinish = false;
            if (start < curEnd) {
                int curStart = child.getStartOffset();
                if (curStart < end) {
                    IJSONSourceFormatter formatter = (IJSONSourceFormatter)((Object)child.getAdapterFor(IJSONSourceFormatter.class));
                    if (formatter == null) {
                        formatter = JSONSourceFormatterFactory.getInstance().getSourceFormatter(child);
                    }
                    childSource = JSONArrayFormatter.includes(region, curStart, curEnd) ? ((AbstractJSONSourceFormatter)formatter).formatProc(child) : ((AbstractJSONSourceFormatter)formatter).formatProc(child, JSONArrayFormatter.overlappedRegion(region, curStart, curEnd));
                } else {
                    toFinish = true;
                }
            }
            if (childSource != null) {
                source.append((CharSequence)childSource);
            }
            if (toFinish) break;
            child = child.getNextSibling();
        }
    }

    @Override
    protected void formatPre(IJSONNode node, StringBuilder source) {
        this.formatPre(node, new FormatRegion(node.getStartOffset(), node.getEndOffset() - node.getStartOffset()), source);
    }

    @Override
    protected void formatPre(IJSONNode node, IRegion region, StringBuilder source) {
        IStructuredDocument document;
        CompoundRegion[] regions;
        IJSONCleanupStrategy stgy = this.getCleanupStrategy(node);
        if (region.getOffset() >= 0 && region.getLength() >= 0 && (regions = this.getRegionsWithoutWhiteSpaces(document = node.getOwnerDocument().getModel().getStructuredDocument(), region, stgy)).length > 0 && regions[0] != null && regions[0].getType() == "JSON_ARRAY_OPEN") {
            source.append(this.decoratedRegion(regions[0], 0, stgy));
        }
        if (node instanceof IJSONArray && node.hasChildNodes()) {
            source.append(this.getLineDelimiter(node));
            source.append(this.getIndent(node));
            source.append(this.getIndentString());
        }
    }

    @Override
    protected void formatPost(IJSONNode node, StringBuilder source) {
        this.formatPost(node, new FormatRegion(node.getStartOffset(), node.getEndOffset() - node.getStartOffset()), source);
    }

    @Override
    protected void formatPost(IJSONNode node, IRegion region, StringBuilder source) {
        CompoundRegion r;
        IStructuredDocument document;
        CompoundRegion[] regions;
        IJSONCleanupStrategy stgy = this.getCleanupStrategy(node);
        if (region.getOffset() >= 0 && region.getLength() >= 0 && (regions = this.getRegionsWithoutWhiteSpaces(document = node.getOwnerDocument().getModel().getStructuredDocument(), region, stgy)).length > 0 && regions[regions.length - 1] != null && (r = regions[regions.length - 1]) != null && r.getType() == "JSON_ARRAY_CLOSE") {
            source.append(this.decoratedRegion(r, 0, stgy));
        }
    }

    public static synchronized JSONArrayFormatter getInstance() {
        if (instance == null) {
            instance = new JSONArrayFormatter();
        }
        return instance;
    }
}

